//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		PPUnit.h
 * @brief		PʌnvvZbTt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_PPUnit_H_
#define INCG_IRIS_PPUnit_H_

//======================================================================
// include
#include "PPConfig.h"

//======================================================================
// define
/// degree -> radian
#define IRIS_Degree2Radian(degree_)		(31416 * (degree_) / 10000 / 180)
/// pixel -> twip
#define IRIS_Pixel2Twip(pixel_, dpi_)	((pixel_) * 1440 / (dpi_))
/// pixel -> point
#define IRIS_Pixel2Point(pixel_, dpi_)	((pixel_) * 72 / (dpi_))
/// pixel -> inch
#define IRIS_Pixel2Inch(pixel_, dpi_)	((pixel_) / (dpi_))
/// inch -> pixel
#define IRIS_Inch2Pixel(inch_, dpi_)	((inch_) * (dpi_))
/// inch -> point
#define IRIS_Inch2Point(inch_)			((inch_) * 72)
/// inch -> twip
#define IRIS_Inch2Twip(inch_)			((inch_) * 1440)
/// point -> pixel
#define IRIS_Point2Pixel(point_, dpi_)	((point_) * (dpi_) / 72)
/// point -> inch
#define IRIS_Point2Inch(point_)			((point_) / 72)
/// point -> twip
#define IRIS_Point2Twip(point_)			((point_) * 20)
/// twip -> pixel
#define IRIS_Twip2Pixel(twip_, dpi_)	((twip_) * (dpi_) / 1440)
/// twip -> inch
#define IRIS_Twip2Inch(twip_)			((twip_) / 1440)
/// twip -> point
#define IRIS_Twip2Point(twip_)			((twip_) / 20)

/// inch -> mm
#define IRIS_Inch2MilliMeter(inch_)		((inch_) * 254 / 10)

#endif	// #ifndef _IRIS_PPUnit_H_
