//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		PPEndian.h
 * @brief		GfBA@vvZbTt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_PPEndian_H_
#define INCG_IRIS_PPEndian_H_

//======================================================================
// include
#include "PPConfig.h"

//======================================================================
// define
/// GfBA](16bit)
#define IRIS_ReverseEndian16(a_)		( ((a_ & 0xFF)<<8) | (((a_)>>8) & 0xFF) )
/// GfBA](32bit)
#define IRIS_ReverseEndian32(a_)		( ((a_ & 0xFF)<<24) | ((((a_)>>8) & 0xFF)<<16) | ((((a_)>>16) & 0xFF)<<8) | (((a_)>>24) & 0xFF) )
/// eGfBAɔ]
#ifdef __BIG_ENDIAN__
#  define IRIS_ToLittleEndian32(a_)		IRIS_ReverseEndian32(a_)
#  define IRIS_ToBigEndian32(a_)		(a_)
#else
#  define IRIS_ToLittleEndian32(a_)		(a_)
#  define IRIS_ToBigEndian32(a_)		IRIS_ReverseEndian32(a_)
#endif

#endif	// #ifndef _IRIS_PPEndian_H_
