//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXSHStream.cpp
 * @brief		Shell Stream t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXSHStream_CPP_

//======================================================================
// include
#include "WXSHStream.h"

namespace iris {
namespace wx
{

//======================================================================
// class

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CSHStream::CSHStream(void)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CSHStream::~CSHStream(void)
{
}

/**********************************************************************//**
 *
 * t@CJ
 *
 ----------------------------------------------------------------------
 * @param [in]	lpszFileName	= t@C
 * @param [in]	grfMode			= STGM_***
 * @return 
*//***********************************************************************/
template<>
bool CSHStream::FileOpen<CHAR>(LPCSTR  lpszFileName, DWORD grfMode)
{
	if( FAILED(SHCreateStreamOnFileA(lpszFileName, grfMode, ptr())) ) return false;
	return true;
}
/**
 * @ref	FileOpen
*/
template<>
bool CSHStream::FileOpen<WCHAR>(LPCWSTR lpszFileName, DWORD grfMode)
{
	if( FAILED(SHCreateStreamOnFileW(lpszFileName, grfMode, ptr())) ) return false;
	return true;
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
//bool CSHStream::Close(void)
//{
//}


}	// end of namespace wx
}	// end of namespace iris
