//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXSHFileSave.cpp
 * @brief		t@Cۑ_CAONX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXSHFileSave_CPP_

//======================================================================
// include
#include "WXSHFileSave.h"
#include "../shlobj_inchead.h"

namespace iris {
namespace wx
{

//======================================================================
// class

/**********************************************************************//**
 *
 * ut@Cۑv_CAO\
 *
 -----------------------------------------------------------------------
 * @param [in]	hwnd			= eEChẼnh
 * @param [in]	lpszTitle		= EBhE^Cg
 * @param [in]	lpszFilter		= tB^[
 * @param [in]	lpszDefExt		= ftHggq
 * @param [out]	lpszFolderName	= tH_̃tpX(߂l)
 * @param [in]	dwSize			= lpszFolderName TCY
 * @param [in]	Flags			= _CAÕtO
 * @param [io]	lpofn			= ݒƏo
 * @retval	TRUE = tH_Iꍇ
*//***********************************************************************/
template<typename CHARTYPE_>
BOOL CTSHFileSave<CHARTYPE_>::Show(HWND hWnd, _Mylpcstr lpszTitle, _Mylpcstr lpszFilter, _Mylpcstr lpszDefExt
						, _Mylpstr lpszFileName, DWORD dwSize, DWORD Flags, LPXOPENFILENAME lpofn)
{
	XOPENFILENAME ofn = {0};
	if( lpofn == nullptr )
	{
		lpofn = &ofn;
	}

	lpofn->lStructSize		= sizeof(XOPENFILENAME);
	lpofn->hwndOwner		= hWnd;
	lpofn->lpstrFilter		= lpszFilter;
	lpofn->lpstrFile		= lpszFileName;
	lpofn->nMaxFile			= dwSize;
	lpofn->Flags			= Flags;
	lpofn->lpstrDefExt		= lpszDefExt;
	lpofn->lpstrTitle		= lpszTitle;
	return (Open(lpofn));
}

/**********************************************************************//**
 *
 * ut@CJv_CAO\
 *
 -----------------------------------------------------------------------
 * @param [io]	lpofn			= ݒƏo
 * @retval	TRUE = tH_Iꍇ
 *//***********************************************************************/
template<>
BOOL CTSHFileSave<CHAR>::Open(LPXOPENFILENAME lpofn)
{
#if	!defined(IRIS_WIN32_WCE)
	return GetSaveFileNameA(lpofn);
#else
	return FALSE;
#endif
}
template<>
BOOL CTSHFileSave<WCHAR>::Open(LPXOPENFILENAME lpofn)
{
	return GetSaveFileNameW(lpofn);
}

template class CTSHFileSave<CHAR>;
template class CTSHFileSave<WCHAR>;

}	// end of namespace wx
}	// end of namespace iris
