//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXSHFileOpen.cpp
 * @brief		t@CI[v_CAONX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXSHFileOpen_CPP_

//======================================================================
// include
#include "WXSHFileOpen.h"
#include "../shlobj_inchead.h"

namespace iris {
namespace wx
{

//======================================================================
// class

/**********************************************************************//**
 *
 * ut@CJv_CAO\
 *
 -----------------------------------------------------------------------
 * @param [in]	hwnd			= eEChẼnh
 * @param [in]	lpszTitle		= EBhE^Cg
 * @param [in]	lpszFilter		= tB^[
 * @param [out]	lpszFolderName	= tH_̃tpX(߂l)
 * @param [in]	dwSize			= lpszFolderName TCY
 * @param [in]	Flags			= _CAÕtO
 * @param [io]	lpofn			= ݒƏo
 * @retval	TRUE = tH_Iꍇ
*//***********************************************************************/
template<typename CHARTYPE_>
BOOL CTSHFileOpen<CHARTYPE_>::Show(HWND hWnd, _Mylpcstr lpszTitle, _Mylpcstr lpszFilter
						, _Mylpstr lpszFileName, DWORD dwSize, DWORD Flags, LPXOPENFILENAME lpofn)
{
	XOPENFILENAME ofn = {0};
	if( lpofn == nullptr )
	{
		lpofn = &ofn;
	}

	lpofn->lStructSize		= sizeof(XOPENFILENAME);
	lpofn->hwndOwner		= hWnd;
	lpofn->lpstrFilter		= lpszFilter;
	lpofn->lpstrFile		= lpszFileName;
	lpofn->nMaxFile			= dwSize;
	lpofn->Flags			= Flags;
	lpofn->lpstrTitle		= lpszTitle;
	return Open(lpofn);
}

/**********************************************************************//**
 *
 * ut@CJv_CAO\
 *
 -----------------------------------------------------------------------
 * @param [io]	lpofn			= ݒƏo
 * @retval	TRUE = tH_Iꍇ
 *//***********************************************************************/
template<>
BOOL CTSHFileOpen<CHAR>::Open(LPXOPENFILENAME lpofn)
{
#if	!defined(IRIS_WIN32_WCE)
	return GetOpenFileNameA(lpofn);
#else
	return FALSE;
#endif
}
template<>
BOOL CTSHFileOpen<WCHAR>::Open(LPXOPENFILENAME lpofn)
{
	return GetOpenFileNameW(lpofn);
}

template class CTSHFileOpen<CHAR>;
template class CTSHFileOpen<WCHAR>;

}	// end of namespace wx
}	// end of namespace iris
