//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXSHChooseFont.h
 * @brief		tHgI_CAONX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXSHChooseFont_H_
#define INCG_IRIS_WXSHChooseFont_H_

//======================================================================
// include
#include "iris_object.h"
#include "../../gdi/WXLogFont.h"
#include <commdlg.h>

namespace iris {
namespace wx
{

//======================================================================
// declare
template<typename CHARTYPE_>class CTSHChooseFont;

//======================================================================
// typedef
typedef CTSHChooseFont<CHAR>	CSHChooseFontA;
typedef CTSHChooseFont<WCHAR>	CSHChooseFontW;
typedef CTSHChooseFont<TCHAR>	CSHChooseFont;

//======================================================================
// class
/**
 * @brief	tHgI_CAONX
*/
template<typename CHARTYPE_>
class CTSHChooseFont : public IIrisObject
{
private:
	typedef CHARTYPE_			_Mychar;
	typedef CHARTYPE_			*_Mylpstr;
	typedef const CHARTYPE_		*_Mylpcstr;
	typedef CTSHChooseFont<CHARTYPE_>	_Myt;
	typedef typename CTLogFont<CHARTYPE_>::XLOGFONT	XLOGFONT;
public:
	typedef XLOGFONT		*LPXLOGFONT;

#if	!defined(IRIS_WIN32_WCE)
	typedef typename iml::type_select< (cpp0x::is_same<_Mychar, WCHAR>::value), CHOOSEFONTW, CHOOSEFONTA >::type XCHOOSEFONT;
	typedef XCHOOSEFONT	*LPXCHOOSEFONT;
#endif

public:
	// J
	static	BOOL	Show(HWND hOwner, LPXLOGFONT lpLogFont, int SizeMin, int SizeMax, DWORD Flags, LPCOLORREF pColor=nullptr, LPINT lpPointSize=nullptr
						  , _Mylpcstr lpTemplateName=nullptr, HINSTANCE hInstance=nullptr, LPCCHOOKPROC lpfnHook=nullptr, LPARAM lCustData=0);

#if	!defined(IRIS_WIN32_WCE)
	// I_CAOJ
	static BOOL		Choose(LPXCHOOSEFONT cf);
#endif

};

}	// end of namespace wx
}	// end of namespace iris

#endif
