//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXSHChooseColor.cpp
 * @brief		J[I_CAONX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXSHChooseColor_CPP_

//======================================================================
// include
#include "WXSHChooseColor.h"
#include "../shlobj_inchead.h"
#include "iris_xchar.hpp"
#include "iris_debug.h"

namespace iris {
namespace wx
{

//======================================================================
// class

/**********************************************************************//**
 *
 * J[I_CAO\
 *
 -----------------------------------------------------------------------
 * @param [in]	hwnd			= eEChẼnh
 * @param [out]	pResult			= o̓J[
 * @param [in]	pCustColors		= JX^J[z
 * @param [in]	Flags			= _CAÕtO
 * @param [in]	lpTemplateName	= _CAOev[g
 * @param [in]	hInstance		= _CAOev[gi[nh
 * @param [in]	lpfnHook		= tbNnh
 * @param [in]	lCustData		= JX^J[
 * @retval	TRUE = tH_Iꍇ
*//***********************************************************************/
template<typename CHARTYPE_>
BOOL CTSHChooseColor<CHARTYPE_>::Show(HWND hOwner, LPCOLORREF pResult, LPCOLORREF pCustColors, DWORD Flags
						  , _Mylpcstr lpTemplateName, HINSTANCE hInstance, LPCCHOOKPROC lpfnHook, LPARAM lCustData)
{
	IRIS_ASSERT(pResult != nullptr);
	XCHOOSECOLOR cc;
	memset(&cc, 0, sizeof(XCHOOSECOLOR));
	cc.lStructSize = sizeof(XCHOOSECOLOR);
	cc.hwndOwner = hOwner;
	cc.rgbResult = *pResult;
	cc.lpCustColors = pCustColors;
	cc.Flags = Flags;

#if	!defined(IRIS_WIN32_WCE) && STRICT
	cc.hInstance = reinterpret_cast<HWND>(hInstance);
#else
	cc.hInstance = hInstance;
#endif

#if	!defined(IRIS_WIN32_WCE) || !defined(UNICODE)
	cc.lpTemplateName = lpTemplateName;
#else
	WCHAR temp[256];
	if( lpTemplateName != nullptr )
	{
		xcstoxcs_s(temp, 256, lpTemplateName);
		cc.lpTemplateName = temp;
	}
#endif
	cc.lpfnHook = lpfnHook;
	cc.lCustData = lCustData;
	if( pCustColors == nullptr )
	{
		COLORREF def[16];
		cc.lpCustColors = def;
		if( !Choose(&cc) ) return FALSE;
	}
	else
	{
		if( !Choose(&cc) ) return FALSE;
	}
	*pResult = cc.rgbResult;
	return TRUE;
}

/**********************************************************************//**
 *
 * J[I_CAO\
 *
 -----------------------------------------------------------------------
 * @param [io]	cc	= ݒƏo
 * @retval	TRUE = tH_Iꍇ
 *//***********************************************************************/
template<>
BOOL CTSHChooseColor<CHAR>::Choose(LPXCHOOSECOLOR cc)
{
#if	!defined(IRIS_WIN32_WCE) || defined(UNDER_NT)
	return ChooseColorA(cc);
#else
	return FALSE;
#endif
}
template<>
BOOL CTSHChooseColor<WCHAR>::Choose(LPXCHOOSECOLOR cc)
{
#if	!defined(IRIS_WIN32_WCE) || defined(UNDER_NT)
	return ChooseColorW(cc);
#else
	return FALSE;
#endif
}

template class CTSHChooseColor<CHAR>;
template class CTSHChooseColor<WCHAR>;

}	// end of namespace wx
}	// end of namespace iris
