//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXSHBrowseFolder.cpp
 * @brief		WXSHBrowseFolder t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXSHBrowseFolder_CPP_

//======================================================================
// include
#include "WXSHBrowseFolder.h"

//======================================================================
// link
#if defined(IRIS_MSC)
#  if	defined(IRIS_WIN32_WCE)
#    pragma comment( lib, "ceshell.lib" )
#  else
#    pragma comment( lib, "shlwapi.lib" )
#  endif
#endif

//======================================================================
// function
#if (_WIN32_IE < 0x0601)
static void SHFree(LPITEMIDLIST pidl)
{
    IMalloc*  pMalloc;
    SHGetMalloc( &pMalloc );
    if( pMalloc != nullptr )
    {
        pMalloc->Free( pidl );
        pMalloc->Release();
    }
}
#endif

namespace iris {
namespace wx
{

static int CALLBACK _BrowseCallbackProc(HWND hWnd, UINT uMsg, LPARAM lParam, LPARAM lpData);

//======================================================================
// class

/**********************************************************************//**
 *
 * utH_Jv_CAO\
 *
 -----------------------------------------------------------------------
 * @param [in]	hwnd			= eEChẼnh
 * @param [in]	lpszTitle		= EBhE^Cg
 * @param [in]	lpszDefault		= tH_̃ftHgIpX
 * @param [out]	lpszFolderName	= tH_̃tpX(߂l)
 * @param [in]	Flags			= _CAÕtO
 * @retval	TRUE = tH_Iꍇ
*//***********************************************************************/
template<>
BOOL CTSHBrowseFolder<CHAR>::Show(HWND hWnd, LPCSTR  lpszTitle, LPCSTR  lpszDefault, LPSTR  lpszFolderName, DWORD Flags)
{
#if !defined(IRIS_WIN32_WCE) || defined(UNDER_NT)
	XBROWSEINFO		bi;
	LPITEMIDLIST	idl;
	CHAR			DisplayName[MAX_PATH];

	bi.hwndOwner		= hWnd;
	bi.pidlRoot			= nullptr;			 // Jn_(nullptrȂdesktop)
	bi.pszDisplayName	= DisplayName;
	bi.lpszTitle		= lpszTitle;
	bi.ulFlags			= Flags;
	bi.lpfn				= _BrowseCallbackProc;
	bi.lParam			= (LPARAM)lpszDefault;
	bi.iImage			= 0;
	// tH_̎Qƃ_CAO\
	idl=Browse(&bi);
	if(idl != nullptr)
	{
		// VXet@CpXɕϊ
		SHGetPathFromIDListA(idl, lpszFolderName);
		// PIDL
		SHFree(idl);
		return TRUE;
	}
#endif
	return FALSE;
}
template<>
BOOL CTSHBrowseFolder<WCHAR>::Show(HWND hWnd, LPCWSTR lpszTitle, LPCWSTR lpszDefault, LPWSTR lpszFolderName, DWORD Flags)
{
#if !defined(IRIS_WIN32_WCE) || defined(UNDER_NT)
	XBROWSEINFO		bi;
#if	defined(IRIS_WIN32_WCE)
	CHAR			DisplayName[MAX_PATH];
#else
	WCHAR			DisplayName[MAX_PATH];
#endif
	LPITEMIDLIST	idl;

	bi.hwndOwner		= hWnd;
	bi.pidlRoot			= nullptr;			 // Jn_(nullptrȂdesktop)
	bi.pszDisplayName	= DisplayName;
#if	defined(IRIS_WIN32_WCE)
	CHAR Title[256];
	wcstombs(Title, lpszTitle, 256);
	bi.lpszTitle		= Title;
#else
	bi.lpszTitle		= lpszTitle;
#endif
	bi.ulFlags			= Flags;
	bi.lpfn				= _BrowseCallbackProc;
#if	defined(IRIS_WIN32_WCE)
	CHAR Default[MAX_PATH];
	wcstombs(Default, lpszDefault, MAX_PATH);
	bi.lParam			= (LPARAM)lpszDefault;
#else
	bi.lParam			= (LPARAM)lpszDefault;
#endif
	bi.iImage			= 0;
	// tH_̎Qƃ_CAO\
#if	defined(IRIS_WIN32_WCE)
	idl=Browse(&bi);
#else
	idl=Browse(&bi);
#endif
	if(idl != nullptr)
	{
		// VXet@CpXɕϊ
		SHGetPathFromIDListW(idl, lpszFolderName);
		// PIDL
		SHFree(idl);
		return TRUE;
	}
#endif
	return FALSE;
}

/**********************************************************************//**
 *
 * ut@CJv_CAO\
 *
 -----------------------------------------------------------------------
 * @param [io]	lpofn			= ݒƏo
 * @retval	TRUE = tH_Iꍇ
 *//***********************************************************************/
template<>
LPITEMIDLIST CTSHBrowseFolder<CHAR>::Browse(LPXBROWSEINFO bi)
{
	return SHBrowseForFolderA(bi);
}
template<>
LPITEMIDLIST CTSHBrowseFolder<WCHAR>::Browse(LPXBROWSEINFO bi)
{
	return SHBrowseForFolderW(bi);
}

template class CTSHBrowseFolder<CHAR>;
template class CTSHBrowseFolder<WCHAR>;


int CALLBACK _BrowseCallbackProc(HWND hWnd, UINT uMsg, LPARAM lParam, LPARAM lpData)
{
	IRIS_UNUSED_VARIABLE(lParam);
    if(uMsg == BFFM_INITIALIZED)
	{
        SendMessage(hWnd, BFFM_SETSELECTION, (WPARAM)TRUE, lpData);
    }
    return 0;
}

}	// end of namespace wx
}	// end of namespace iris
