//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXSHAbout.cpp
 * @brief		ShellAbout t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXSHAbout_CPP_

//======================================================================
// include
#include "WXSHAbout.h"
#include <shellapi.h>
#include <string>
#include <tchar.h>

#include "iris_debug.h"

//======================================================================
// define
#ifndef VERSIONDLG_SEPARATOR_CHAR
	#define VERSIONDLG_SEPARATOR_CHAR	TEXT('-')
#endif
#ifndef VERSIONDLG_SEPARATOR_CHARNUM
	#define VERSIONDLG_SEPARATOR_CHARNUM	(30)
#endif

#define NL								TEXT("\n")

//======================================================================
// link
#if defined(IRIS_MSC)
#  if	defined(IRIS_WIN32_WCE)
#    pragma comment( lib, "ceshell.lib" )
#  else
#    pragma comment( lib, "shlwapi.lib" )
#  endif
#endif

namespace iris {
namespace wx
{

//======================================================================
// declare
static void _VersionDlg_MakeComment(CVersionInfo& vi, std::_tstring& str, int table[]);

//======================================================================
// class

/**********************************************************************//**
 *
 * About _CAO\
 *
 -----------------------------------------------------------------------
 * @param [in]	hParent			= eEChẼnh
 * @param [in]	AppName			= AvP[V
 * @param [in]	Comment			= Rg
 * @param [in]	hIcon			= ACR
 * @return	_CAO̖߂l
*//***********************************************************************/
template<>
INT CSHAbout::Show<CHAR>(HWND hParent, LPCSTR  AppName, LPCSTR  Comment, HICON hIcon)
{
	return ::ShellAboutA(hParent, AppName, Comment, hIcon);
}
template<>
INT CSHAbout::Show<WCHAR>(HWND hParent, LPCWSTR AppName, LPCWSTR Comment, HICON hIcon)
{
	return ::ShellAboutW(hParent, AppName, Comment, hIcon);
}

/**********************************************************************//**
 *
 * ShellAboutĂяo
 *  VersionInfo\[XeLXgݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hParent	= eEBhEnh
 * @param [in]	nFlags	= \eLXgtOiVERSIONDLG_MASKj
 * @param [in]	hIcon	= ACR
 * @return	_CAO̖߂l
*//***********************************************************************/
INT	CSHAbout::ShowFromVersionInfo(HWND hParent, int nMask, HICON hIcon)
{
	int id_table[CVersionInfo::TERM];
	int c=0;
	for( int i=0; i < CVersionInfo::TERM; ++i )
	{
		if( nMask & (1<<i) )
		{
			id_table[c++] = i;
		}
	}
	id_table[c] = VERDLG_MASK_TERM;
	return ShowFromVersionInfoEx(hParent, id_table, hIcon);
}

/**********************************************************************//**
 *
 * ShellAboutĂяo
 *  VersionInfo\[XeLXgݒ
 *
 * @note	VERDLG_MASK_SEPARATOR, VERDLG_MASK_RETURNw\
 *
 ----------------------------------------------------------------------
 * @param [in]	hParent		= eEBhEnh
 * @param [in]	id_table	= \eLXgtOi VERSIONDLG_ID ̔zAI[ VERDLG_ID_TERM j
 * @param [in]	hIcon		= ACR
 * @return	_CAO̖߂l
*//***********************************************************************/
INT	CSHAbout::ShowFromVersionInfoEx(HWND hParent, int id_table[], HICON hIcon)
{
	CVersionInfo vi;
	if( !vi.Open() )
	{
		IRIS_WARNING( "VERSIONINFO܂B" );
		return 0;
	}

	LPTSTR pFileName;
	LPTSTR pVersion;
	if( vi.GetProductName(&pFileName) == 0 ) return 0;
	if( vi.GetProductVersion(&pVersion) == 0 ) return 0;
	// AppName
	std::_tstring app = TEXT("Version information on \"");
	app += pFileName;
	app += TEXT("\"");
	app += NL;
	// Version
	std::_tstring ver = pVersion;
	LPTSTR p = (LPTSTR)_tcschr( ver.c_str(), TEXT(','));
	while( p )
	{
		*p = TEXT('.');	// .ɒ
		p = _tcschr( p, TEXT(','));
	}
	app += TEXT("#");
	app += pFileName;
	app += TEXT(" Version ");
	app += ver.c_str();
	// Comment
	std::_tstring comm;
	_VersionDlg_MakeComment(vi, comm, id_table);

	return Show(hParent, app.c_str(), comm.c_str(), hIcon);
}

/**********************************************************************//**
 * @internal
 *
 * RgeLXg̐
 *
 ----------------------------------------------------------------------
 * @param [in]	vi		= o[W
 * @param [out]	str		= o
 * @param [in]	table	= ID e[u
*//***********************************************************************/
void _VersionDlg_MakeComment(CVersionInfo& vi, std::_tstring& str, int table[])
{
	str = TEXT("");
	int *tbl = table;
	for( ; *tbl != VERDLG_MASK_TERM; ++tbl)
	{
		int id = *tbl;
		switch( id )
		{
		case VERDLG_ID_SEPARATOR:
			{
				for( int i=0; i < VERSIONDLG_SEPARATOR_CHARNUM; ++i )
					str += VERSIONDLG_SEPARATOR_CHAR;
				str += NL;
			}
			break;
		case VERDLG_ID_RETURN:
			str += NL;
			break;
		default:
			{
				LPTSTR txt;
				if( vi.GetStringFileInfoFromID(id, &txt) )
				{
					str += txt;
					str += NL;
				}
			}
			break;
		}
	}
}

}	// end of namespace wx
}	// end of namespace iris
