//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXDropHandle.cpp
 * @brief		HDROPNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXDropHandle_CPP_

//======================================================================
// include
#include "WXDropHandle.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CDropHandle::CDropHandle(void)
: m_hDrop(nullptr)
{
}

/**********************************************************************//**
 *
 * RXgN^
 *
 -----------------------------------------------------------------------
 * @param [in]	hDrop	= ֘Atnh
*//***********************************************************************/
CDropHandle::CDropHandle(HDROP hDrop)
: m_hDrop(nullptr)
{
	Attach(hDrop);
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CDropHandle::~CDropHandle(void)
{
	Finish();
}

/**********************************************************************//**
 *
 * ֘At
 *
 -----------------------------------------------------------------------
 * @param [in]	hDrop	= ֘Atnh
 * @return 
*//***********************************************************************/
BOOL CDropHandle::Attach(HDROP hDrop)
{
	if( m_hDrop != nullptr || hDrop == nullptr ) return FALSE;
	m_hDrop = hDrop;
	return TRUE;
}

/**********************************************************************//**
 *
 * ֘At̉
 *
 -----------------------------------------------------------------------
 * @return ȑÕnh
*//***********************************************************************/
HDROP CDropHandle::Detach(void)
{
	HDROP hPre = m_hDrop;
	m_hDrop = nullptr;
	return hPre;
}

/**********************************************************************//**
 *
 * I
 *
*//***********************************************************************/
void CDropHandle::Finish(void)
{
	if( m_hDrop != nullptr ) DragFinish(m_hDrop);
}

/**********************************************************************//**
 *
 * ̎擾
 *
 -----------------------------------------------------------------------
 * @param [in]	uFlags		= tO
 * @param [out]	lpBuffer	= o̓obt@
 * @param [in]	uSize		= o̓obt@TCY
 * @return ݃TCY
*//***********************************************************************/
template<>
UINT CDropHandle::QueryFile<CHAR>(UINT uFlags, LPSTR  lpBuffer, UINT uSize)
{
	return DragQueryFileA(m_hDrop, uFlags, lpBuffer, uSize);
}
/// iris::wx::QueryFile Q
template<>
UINT CDropHandle::QueryFile<WCHAR>(UINT uFlags, LPWSTR lpBuffer, UINT uSize)
{
	return DragQueryFileW(m_hDrop, uFlags, lpBuffer, uSize);
}

/**********************************************************************//**
 *
 * hbvʒu̎擾
 *
 -----------------------------------------------------------------------
 * @param [out]	lppt	= o͍W
 * @return 
*//***********************************************************************/
BOOL CDropHandle::QueryPoint(LPPOINT lppt)
{
	return DragQueryPoint(m_hDrop, lppt);
}

}	// end of namespace wx
}	// end of namespace iris
