//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXRtlBackTrace.h
 * @brief		WXRtlBackTrace t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2012 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXRtlBackTrace_H_
#define INCG_IRIS_WXRtlBackTrace_H_

//======================================================================
// include
#include "../os/modules/WXMNtDll.h"

namespace iris {
namespace wx
{

/**
 * @brief	RTL obNg[X
*/
template<int N>
class CRtlBackTrace : public IIrisObject
{
	static const int NUM = N;

	void*	m_Stack[N];
	WORD	m_Count;
public:
	CRtlBackTrace(void)
		: m_Count(0)
	{
		m_Count = CNtDllModule::RtlCaptureStackBackTrace(2, NUM, m_Stack, nullptr);
	}
public:
	const void*	GetAt(int index)	const	{ return m_Stack[index]; }
	WORD		GetCount(void)		const	{ return m_Count; }
public:
	const void*	operator [] (int index) const	{ return m_Stack[index]; }
};

}	// end of namespace wx
}	// end of namespace iris

#endif
