//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXMMsimg.h
 * @brief		Msimg t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXMMsimg_H_
#define INCG_IRIS_WXMMsimg_H_

//======================================================================
// include
#include "../WXModule.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/**
 * @brief	Msimg NX
*/
class CMsimg : private INonCopyable<CMsimg>
{
	CModule m_Module;
private:
	// RXgN^
	CMsimg(void)		{ Load(); }

	// CX^X̎擾
	static	CMsimg&	GetInstance(void)	{ static CMsimg Msimg; return Msimg; }
	// W[̃[h
	BOOL	Load(void)
	{
		if( m_Module.IsValid() ) return TRUE;
		return m_Module.Load(IRIS_TEXT("msimg32.dll"));
	}
	// W[̃A[h
	BOOL	Unload(void)
	{
		return m_Module.Release();
	}

#define PROC_LOAD(_ret, _name, _args, _err)			\
	typedef _ret (__stdcall *pfn##_name)##_args;	\
	static pfn##_name	pfnProc = nullptr;			\
	do {											\
	if( pfnProc == nullptr ) {						\
		GetInstance().Load();						\
		pfnProc = GetProcAddress<pfn##_name>(#_name);	\
		if( pfnProc == nullptr ) return _err;		\
	} } while(0)

public:
	/**
	 * @name	wrap
	 * @{
	*/
	static BOOL AlphaBlend(HDC hdcDest, int xoriginDest, int yoriginDest, int wDest, int hDest
		, HDC hdcSrc, int xoriginSrc, int yoriginSrc, int wSrc, int hSrc, BLENDFUNCTION ftn)
	{
		PROC_LOAD(BOOL, AlphaBlend, (HDC hdcDest, int xoriginDest, int yoriginDest, int wDest, int hDest, HDC hdcSrc, int xoriginSrc, int yoriginSrc, int wSrc, int hSrc, BLENDFUNCTION ftn), FALSE);
		return pfnProc(hdcDest, xoriginDest, yoriginDest, wDest, hDest, hdcSrc, xoriginSrc, yoriginSrc, wSrc, hSrc, ftn);
	}

	static BOOL GradientFill(HDC hdc, PTRIVERTEX pVertex, ULONG nVertex, PVOID pMesh, ULONG nMesh, ULONG ulMode)
	{
		PROC_LOAD(BOOL, AlphaBlend, (HDC hdc, PTRIVERTEX pVertex, ULONG nVertex, PVOID pMesh, ULONG nMesh, ULONG ulMode), FALSE);
		return pfnProc(hdc, pVertex, nVertex, pMesh, nMesh, ulMode);
	}
	/**
	 * @}
	*/

#undef PROC_LOAD

public:
	// AhX擾
	template<typename F, typename CHARTYPE_>
	static F	GetProcAddress(const CHARTYPE_ * lpProcName)
	{
IRIS_MSC_PRAGMA_WARNING_BEGIN()
IRIS_MSC_PRAGMA_WARNING_DISABLE(4191)	// PROC  hoge ւ̕ϊ͕ۏ؂܂B
		return reinterpret_cast<F>(GetInstance().m_Module.GetProcAddress(lpProcName));
IRIS_MSC_PRAGMA_WARNING_END()
	}

};

}	// end of namespace wx
}	// end of namespace iris

#endif
