//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXMKernel.h
 * @brief		kernel t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXMKernel_H_
#define INCG_IRIS_WXMKernel_H_

//======================================================================
// include
#include "../WXModule.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/**
 * @brief	kernel NX
*/
class CKernel : private INonCopyable<CKernel>
{
	CModule m_Module;
private:
	// RXgN^
	CKernel(void)		{ Load(); }

	// CX^X̎擾
	static	CKernel&	GetInstance(void)	{ static CKernel kernel; return kernel; }
	// W[̃[h
	BOOL	Load(void)
	{
		if( m_Module.IsValid() ) return TRUE;
		return m_Module.Load(IRIS_TEXT("kernel32.dll"));
	}
	// W[̃A[h
	BOOL	Unload(void)
	{
		return m_Module.Release();
	}

#define PROC_LOAD(_ret, _name, _args, _err)			\
	typedef _ret (__stdcall *pfn##_name)##_args;	\
	static pfn##_name	pfnProc = nullptr;			\
	do {											\
	if( pfnProc == nullptr ) {						\
		GetInstance().Load();						\
		pfnProc = GetProcAddress<pfn##_name>(#_name);	\
		if( pfnProc == nullptr ) return _err;		\
	} } while(0)

public:
	/**
	 * @name	wrap
	 * @{
	*/
#if	!defined(IRIS_WIN32_WCE)
	static BOOL GetNamedPipeAttribute(HANDLE Pipe, PIPE_ATTRIBUTE_TYPE AttributeType, PSTR AttributeName, PVOID AttributeValue, PSIZE_T AttributeValueLength)
	{
		PROC_LOAD(BOOL, GetNamedPipeAttribute, (HANDLE Pipe, PIPE_ATTRIBUTE_TYPE AttributeType, PSTR AttributeName, PVOID AttributeValue, PSIZE_T AttributeValueLengt), FALSE);
		return pfnProc(Pipe, AttributeType, AttributeName, AttributeValue, AttributeValueLength);
	}
	static BOOL	SetNamedPipeAttribute(HANDLE Pipe, PIPE_ATTRIBUTE_TYPE AttributeType, PSTR AttributeName, PVOID AttributeValue, SIZE_T AttributeValueLength)
	{
		PROC_LOAD(BOOL, SetNamedPipeAttribute, (HANDLE Pipe, PIPE_ATTRIBUTE_TYPE AttributeType, PSTR AttributeName, PVOID AttributeValue, SIZE_T AttributeValueLength), FALSE);
		return pfnProc(Pipe, AttributeType, AttributeName, AttributeValue, AttributeValueLength);
	}
#endif

	static BOOL	GetNamedPipeClientComputerNameA(HANDLE Pipe, LPSTR  ClientComputerName, ULONG ClientComputerNameLength)
	{
		PROC_LOAD(BOOL, GetNamedPipeClientComputerNameA, (HANDLE Pipe, LPSTR  ClientComputerName, ULONG ClientComputerNameLength), FALSE);
		return pfnProc(Pipe, ClientComputerName, ClientComputerNameLength);
	}
	static BOOL	GetNamedPipeClientComputerNameW(HANDLE Pipe, LPWSTR ClientComputerName, ULONG ClientComputerNameLength)
	{
		PROC_LOAD(BOOL, GetNamedPipeClientComputerNameW, (HANDLE Pipe, LPWSTR ClientComputerName, ULONG ClientComputerNameLength), FALSE);
		return pfnProc(Pipe, ClientComputerName, ClientComputerNameLength);
	}

	static BOOL	GetNamedPipeClientProcessId(HANDLE Pipe, PULONG ClientProcessId)
	{
		PROC_LOAD(BOOL, GetNamedPipeClientProcessId, (HANDLE Pipe, PULONG ClientProcessId), FALSE);
		return pfnProc(Pipe, ClientProcessId);
	}
	static BOOL	GetNamedPipeClientSessionId(HANDLE Pipe, PULONG ServerProcessId)
	{
		PROC_LOAD(BOOL, GetNamedPipeClientSessionId, (HANDLE Pipe, PULONG ServerProcessId), FALSE);
		return pfnProc(Pipe, ServerProcessId);
	}
	static BOOL	GetNamedPipeServerProcessId(HANDLE Pipe, PULONG ClientProcessId)
	{
		PROC_LOAD(BOOL, GetNamedPipeServerProcessId, (HANDLE Pipe, PULONG ClientProcessId), FALSE);
		return pfnProc(Pipe, ClientProcessId);
	}
	static BOOL	GetNamedPipeServerSessionId(HANDLE Pipe, PULONG ServerSessionId)
	{
		PROC_LOAD(BOOL, GetNamedPipeServerSessionId, (HANDLE Pipe, PULONG ServerSessionId), FALSE);
		return pfnProc(Pipe, ServerSessionId);
	}

	// http://msdn.microsoft.com/en-us/library/dd317756.aspx
	static UINT	GetConsoleCP(void)
	{
		PROC_LOAD(UINT, GetConsoleCP, (void), 0);
		return pfnProc();
	}

	static BOOL	SetConsoleCP(UINT wCodePageID)
	{
		PROC_LOAD(BOOL, SetConsoleCP, (UINT wCodePageID), FALSE);
		return pfnProc(wCodePageID);
	}

	static UINT	GetConsoleOutputCP(void)
	{
		PROC_LOAD(UINT, GetConsoleOutputCP, (void), 0);
		return pfnProc();
	}

	static BOOL	SetConsoleOutputCP(UINT wCodePageID)
	{
		PROC_LOAD(BOOL, SetConsoleOutputCP, (UINT wCodePageID), FALSE);
		return pfnProc(wCodePageID);
	}

#if	!defined(IRIS_WIN32_WCE)
	static BOOL	GetConsoleScreenBufferInfoEx(HANDLE hConsoleOutput, PCONSOLE_SCREEN_BUFFER_INFOEX lpConsoleScreenBufferInfoEx)
	{
		PROC_LOAD(BOOL, GetConsoleScreenBufferInfoEx, (HANDLE hConsoleOutput, PCONSOLE_SCREEN_BUFFER_INFOEX lpConsoleScreenBufferInfoEx), FALSE);
		return pfnProc(hConsoleOutput, lpConsoleScreenBufferInfoEx);
	}
	static BOOL	SetConsoleScreenBufferInfoEx(HANDLE hConsoleOutput, PCONSOLE_SCREEN_BUFFER_INFOEX lpConsoleScreenBufferInfoEx)
	{
		PROC_LOAD(BOOL, SetConsoleScreenBufferInfoEx, (HANDLE hConsoleOutput, PCONSOLE_SCREEN_BUFFER_INFOEX lpConsoleScreenBufferInfoEx), FALSE);
		return pfnProc(hConsoleOutput, lpConsoleScreenBufferInfoEx);
	}
#endif

	static BOOL GetNativeSystemInfo(LPSYSTEM_INFO lpsi)
	{
		PROC_LOAD(void, GetNativeSystemInfo, (LPSYSTEM_INFO lpsi), FALSE);
		pfnProc(lpsi);
		return TRUE;
	}

	static BOOL IsWow64Process(HANDLE hProcess, PBOOL pbIsWow64)
	{
		PROC_LOAD(BOOL, IsWow64Process, (HANDLE hProcess, PBOOL pbIsWow64), FALSE);
		return pfnProc(hProcess, pbIsWow64);
	}
	static BOOLEAN Wow64EnableWow64FsRedirection(BOOLEAN bEnable)
	{
		PROC_LOAD(BOOLEAN, Wow64EnableWow64FsRedirection, (BOOLEAN bEnable), FALSE);
		return pfnProc(bEnable);
	}
	static BOOLEAN Wow64DisableWow64FsRedirection(PVOID* OldValue)
	{
		PROC_LOAD(BOOLEAN, Wow64DisableWow64FsRedirection, (PVOID* OldValue), FALSE);
		return pfnProc(OldValue);
	}
	static BOOLEAN Wow64RevertWow64FsRedirection(PVOID OldValue)
	{
		PROC_LOAD(BOOLEAN, Wow64RevertWow64FsRedirection, (PVOID OldValue), FALSE);
		return pfnProc(OldValue);
	}

	static UINT GetErrorMode(void)
	{
		PROC_LOAD(UINT, GetErrorMode, (void), 0);
		return pfnProc();
	}
	/**
	 * @}
	*/

#undef PROC_LOAD

public:
	// AhX擾
	template<typename F, typename CHARTYPE_>
	static F	GetProcAddress(const CHARTYPE_ * lpProcName)
	{
IRIS_MSC_PRAGMA_WARNING_BEGIN()
IRIS_MSC_PRAGMA_WARNING_DISABLE(4191)	// PROC  hoge ւ̕ϊ͕ۏ؂܂B
		return reinterpret_cast<F>(GetInstance().m_Module.GetProcAddress(lpProcName));
IRIS_MSC_PRAGMA_WARNING_END()
	}
};

}	// end of namespace wx
}	// end of namespace iris

#endif
