//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXMDbgHelp.h
 * @brief		DbgHelp t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011-2012 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXMDbgHelp_H_
#define INCG_IRIS_WXMDbgHelp_H_

//======================================================================
// include
#include "../WXModule.h"

#if !defined(_IMAGEHLP_)
#  include <dbghelp.h>
#endif

namespace iris {
namespace wx
{

//======================================================================
// class
/**
 * @brief	DbgHelp W[NX
*/
class CDbgHelpModule : private INonCopyable<CDbgHelpModule>
{
	CModule m_Module;
#if defined(_IMAGEHLP64)
	typedef PIMAGEHLP_LINE64	PXIMAGEHLP_LINE;
	typedef PIMAGEHLP_SYMBOL64	PXIMAGEHLP_SYMBOL;
	typedef PSYM_ENUMSYMBOLS_CALLBACK64		PXSYM_ENUMSYMBOLS_CALLBACK;
	typedef PSYM_ENUMSYMBOLS_CALLBACK64W	PXSYM_ENUMSYMBOLS_CALLBACKW;
	typedef PSYM_ENUMMODULES_CALLBACK64		PXSYM_ENUMMODULES_CALLBACK;
#else
	typedef PIMAGEHLP_LINE		PXIMAGEHLP_LINE;
	typedef PIMAGEHLP_SYMBOL	PXIMAGEHLP_SYMBOL;
	typedef PSYM_ENUMSYMBOLS_CALLBACK		PXSYM_ENUMSYMBOLS_CALLBACK;
	typedef PSYM_ENUMSYMBOLS_CALLBACKW		PXSYM_ENUMSYMBOLS_CALLBACKW;
	typedef PSYM_ENUMMODULES_CALLBACK		PXSYM_ENUMMODULES_CALLBACK;
#endif
private:
	// RXgN^
	CDbgHelpModule(void)		{ Load(); }

	// CX^X̎擾
	static	CDbgHelpModule&	GetInstance(void)	{ static CDbgHelpModule DbgHelp; return DbgHelp; }
	// W[̃[h
	BOOL	Load(void)
	{
		if( m_Module.IsValid() ) return TRUE;
		return m_Module.Load(IRIS_TEXT("dbghelp.dll"));
	}
	// W[̃A[h
	BOOL	Unload(void)
	{
		return m_Module.Release();
	}

#define PROC_LOAD(_ret, _name, _args, _err)			\
	typedef _ret (__stdcall *pfn##_name)##_args;	\
	static pfn##_name	pfnProc = nullptr;			\
	do {											\
	if( pfnProc == nullptr ) {						\
		GetInstance().Load();						\
		pfnProc = GetProcAddress<pfn##_name>(#_name);	\
		if( pfnProc == nullptr ) return _err;		\
	} } while(0)

public:
	/**
	 * @name	wrap
	 * @{
	*/
	static BOOL SymInitialize(HANDLE hProcess, PCSTR UserSearchPath, BOOL fInvadeProcess)
	{
		PROC_LOAD(BOOL, SymInitialize, (HANDLE hProcess, PCSTR UserSearchPath, BOOL fInvadeProcess), FALSE);
		return pfnProc(hProcess, UserSearchPath, fInvadeProcess);
	}
	static BOOL SymCleanup(HANDLE hProcess)
	{
		PROC_LOAD(BOOL, SymCleanup, (HANDLE hProcess), FALSE);
		return pfnProc(hProcess);
	}
	static DWORD SymLoadModule(HANDLE hProcess, HANDLE hFile, PCSTR ImageName, PCSTR ModuleName, XDWORD BaseOfDll, DWORD SizeOfDll)
	{
#if defined(_IMAGEHLP64)
		PROC_LOAD(DWORD, SymLoadModule64, (HANDLE hProcess, HANDLE hFile, PCSTR ImageName, PCSTR ModuleName, XDWORD BaseOfDll, DWORD SizeOfDll), 0);
#else
		PROC_LOAD(DWORD, SymLoadModule, (HANDLE hProcess, HANDLE hFile, PCSTR ImageName, PCSTR ModuleName, XDWORD BaseOfDll, DWORD SizeOfDll), 0);
#endif
		return pfnProc(hProcess, hFile, ImageName, ModuleName, BaseOfDll, SizeOfDll);
	}
	static BOOL SymUnloadModule(HANDLE hProcess, DWORD BaseOfDll)
	{
		PROC_LOAD(BOOL, SymUnloadModule, (HANDLE hProcess, DWORD BaseOfDll), FALSE);
		return pfnProc(hProcess, BaseOfDll);
	}
	static BOOL SymSetSearchPath(HANDLE hProcess, PCSTR SearchPath)
	{
		PROC_LOAD(BOOL, SymSetSearchPath, (HANDLE hProcess, PCSTR SearchPath), FALSE);
		return pfnProc(hProcess, SearchPath);
	}
	static BOOL SymGetSearchPath(HANDLE hProcess, PSTR SearchPath, DWORD SearchPathLength)
	{
		PROC_LOAD(BOOL, SymGetSearchPath, (HANDLE hProcess, PSTR SearchPath, DWORD SearchPathLength), FALSE);
		return pfnProc(hProcess, SearchPath, SearchPathLength);
	}
	static BOOL SymRegisterCallback(HANDLE hProcess, PSYMBOL_REGISTERED_CALLBACK CallbackFunction, PVOID UserContext)
	{
		PROC_LOAD(BOOL, SymRegisterCallback, (HANDLE hProcess, PSYMBOL_REGISTERED_CALLBACK CallbackFunction, PVOID UserContext), FALSE);
		return pfnProc(hProcess, CallbackFunction, UserContext);
	}
	static BOOL SymRegisterFunctionEntryCallback(HANDLE hProcess, PSYMBOL_FUNCENTRY_CALLBACK CallbackFunction, PVOID UserContext)
	{
		PROC_LOAD(BOOL, SymRegisterFunctionEntryCallback, (HANDLE hProcess, PSYMBOL_FUNCENTRY_CALLBACK CallbackFunction, PVOID UserContext), FALSE);
		return pfnProc(hProcess, CallbackFunction, UserContext);
	}
	static DWORD SymSetOptions(DWORD SymOptions)
	{
		PROC_LOAD(DWORD, SymSetOptions, (DWORD SymOptions), 0);
		return pfnProc(SymOptions);
	}
	static DWORD SymGetOptions(void)
	{
		PROC_LOAD(DWORD, SymGetOptions, (), 0);
		return pfnProc();
	}
	static BOOL SymGetSymPrev(HANDLE hProcess, PXIMAGEHLP_SYMBOL Symbol)
	{
#if defined(_IMAGEHLP64)
		PROC_LOAD(BOOL, SymGetSymPrev64, (HANDLE hProcess, PXIMAGEHLP_SYMBOL Symbol), FALSE);
#else
		PROC_LOAD(BOOL, SymGetSymPrev, (HANDLE hProcess, PXIMAGEHLP_SYMBOL Symbol), FALSE);
#endif
		return pfnProc(hProcess, Symbol);
	}
	static BOOL SymGetSymNext(HANDLE hProcess, PXIMAGEHLP_SYMBOL Symbol)
	{
#if defined(_IMAGEHLP64)
		PROC_LOAD(BOOL, SymGetSymNext64, (HANDLE hProcess, PXIMAGEHLP_SYMBOL Symbol), FALSE);
#else
		PROC_LOAD(BOOL, SymGetSymNext, (HANDLE hProcess, PXIMAGEHLP_SYMBOL Symbol), FALSE);
#endif
		return pfnProc(hProcess, Symbol);
	}
	static BOOL SymGetSymFromName(HANDLE hProcess, PCSTR Name, PXIMAGEHLP_SYMBOL Symbol)
	{
#if defined(_IMAGEHLP64)
		PROC_LOAD(BOOL, SymGetSymFromName64, (HANDLE hProcess, PCSTR Name, PXIMAGEHLP_SYMBOL Symbol), FALSE);
#else
		PROC_LOAD(BOOL, SymGetSymFromName, (HANDLE hProcess, PCSTR Name, PXIMAGEHLP_SYMBOL Symbol), FALSE);
#endif
		return pfnProc(hProcess, Name, Symbol);
	}
	static BOOL SymGetSymFromAddr(HANDLE hProcess, XDWORD dwAddr, PXDWORD pdwDisplacement, PXIMAGEHLP_SYMBOL Symbol)
	{
#if defined(_IMAGEHLP64)
		PROC_LOAD(BOOL, SymGetSymFromAddr64, (HANDLE hProcess, XDWORD dwAddr, PXDWORD pdwDisplacement, PXIMAGEHLP_SYMBOL Symbol), FALSE);
#else
		PROC_LOAD(BOOL, SymGetSymFromAddr, (HANDLE hProcess, XDWORD dwAddr, PXDWORD pdwDisplacement, PXIMAGEHLP_SYMBOL Symbol), FALSE);
#endif
		return pfnProc(hProcess, dwAddr, pdwDisplacement, Symbol);
	}
	static BOOL SymGetLinePrev(HANDLE hProcess, PXIMAGEHLP_LINE Line)
	{
#if defined(_IMAGEHLP64)
		PROC_LOAD(BOOL, SymGetLinePrev64, (HANDLE hProcess, PXIMAGEHLP_LINE Line), FALSE);
#else
		PROC_LOAD(BOOL, SymGetLinePrev, (HANDLE hProcess, PXIMAGEHLP_LINE Line), FALSE);
#endif
		return pfnProc(hProcess, Line);
	}
	static BOOL SymGetLineNext(HANDLE hProcess, PXIMAGEHLP_LINE Line)
	{
#if defined(_IMAGEHLP64)
		PROC_LOAD(BOOL, SymGetLineNext64, (HANDLE hProcess, PXIMAGEHLP_LINE Line), FALSE);
#else
		PROC_LOAD(BOOL, SymGetLineNext, (HANDLE hProcess, PXIMAGEHLP_LINE Line), FALSE);
#endif
		return pfnProc(hProcess, Line);
	}
	static BOOL SymGetLineFromName(HANDLE hProcess, PCSTR ModuleName, PCSTR FileName, DWORD dwLineNumber, PLONG plDisplacement, PXIMAGEHLP_LINE Line)
	{
#if defined(_IMAGEHLP64)
		PROC_LOAD(BOOL, SymGetLineFromName64, (HANDLE hProcess, PCSTR ModuleName, PCSTR FileName, DWORD dwLineNumber, PLONG plDisplacement, PXIMAGEHLP_LINE Line), FALSE);
#else
		PROC_LOAD(BOOL, SymGetLineFromName, (HANDLE hProcess, PCSTR ModuleName, PCSTR FileName, DWORD dwLineNumber, PLONG plDisplacement, PXIMAGEHLP_LINE Line), FALSE);
#endif
		return pfnProc(hProcess, ModuleName, FileName, dwLineNumber, plDisplacement, Line);
	}
	static BOOL SymGetLineFromAddr(HANDLE hProcess, XDWORD dwAddr, PDWORD pdwDisplacement, PXIMAGEHLP_LINE Line)
	{
#if defined(_IMAGEHLP64)
		PROC_LOAD(BOOL, SymGetLineFromAddr64, (HANDLE hProcess, XDWORD dwAddr, PDWORD pdwDisplacement, PXIMAGEHLP_LINE Line), FALSE);
#else
		PROC_LOAD(BOOL, SymGetLineFromAddr, (HANDLE hProcess, XDWORD dwAddr, PDWORD pdwDisplacement, PXIMAGEHLP_LINE Line), FALSE);
#endif
		return pfnProc(hProcess, dwAddr, pdwDisplacement, Line);
	}
	static BOOL SymGetModuleInfo(HANDLE hProcess, DWORD dwAddr, PIMAGEHLP_MODULE ModuleInfo)
	{
		PROC_LOAD(BOOL, SymGetModuleInfo, (HANDLE hProcess, DWORD dwAddr, PIMAGEHLP_MODULE ModuleInfo), FALSE);
		return pfnProc(hProcess, dwAddr, ModuleInfo);
	}
	static PGET_MODULE_BASE_ROUTINE GetSymGetModuleBaseProc(void)
	{
#if defined(_IMAGEHLP64)
		PROC_LOAD(DWORD, SymGetModuleBase64, (HANDLE hProcess, XDWORD dwAddr), 0);
#else
		PROC_LOAD(DWORD, SymGetModuleBase, (HANDLE hProcess, XDWORD dwAddr), 0);
#endif
		return pfnProc;
	}
	static DWORD SymGetModuleBase(HANDLE hProcess, XDWORD dwAddr)
	{
		return GetSymGetModuleBaseProc()(hProcess, dwAddr);
	}
	static PFUNCTION_TABLE_ACCESS_ROUTINE GetSymFunctionTableAccessProc(void)
	{
#if defined(_IMAGEHLP64)
		PROC_LOAD(PVOID, SymFunctionTableAccess64, (HANDLE hProcess, XDWORD AddrBase), NULL);
#else
		PROC_LOAD(PVOID, SymFunctionTableAccess, (HANDLE hProcess, XDWORD AddrBase), NULL);
#endif
		return pfnProc;
	}
	static PVOID SymFunctionTableAccess(HANDLE hProcess, XDWORD AddrBase)
	{
		return GetSymFunctionTableAccessProc()(hProcess, AddrBase);
	}
	static BOOL SymEnumerateSymbols(HANDLE hProcess, XULONG BaseOfDll, PXSYM_ENUMSYMBOLS_CALLBACK EnumSymbolsCallback, PVOID UserContext)
	{
#if defined(_IMAGEHLP64)
		PROC_LOAD(BOOL, SymEnumerateSymbols64, (HANDLE hProcess, XULONG BaseOfDll, PXSYM_ENUMSYMBOLS_CALLBACK EnumSymbolsCallback, PVOID UserContext), FALSE);
#else
		PROC_LOAD(BOOL, SymEnumerateSymbols, (HANDLE hProcess, XULONG BaseOfDll, PXSYM_ENUMSYMBOLS_CALLBACK EnumSymbolsCallback, PVOID UserContext), FALSE);
#endif
		return pfnProc(hProcess, BaseOfDll, EnumSymbolsCallback, UserContext);
	}
	static BOOL SymEnumerateSymbolsW(HANDLE hProcess, XULONG BaseOfDll, PXSYM_ENUMSYMBOLS_CALLBACKW EnumSymbolsCallback, PVOID UserContext)
	{
#if defined(_IMAGEHLP64)
		PROC_LOAD(BOOL, SymEnumerateSymbolsW64, (HANDLE hProcess, XULONG BaseOfDll, PXSYM_ENUMSYMBOLS_CALLBACKW EnumSymbolsCallback, PVOID UserContext), FALSE);
#else
		PROC_LOAD(BOOL, SymEnumerateSymbolsW, (HANDLE hProcess, XULONG BaseOfDll, PXSYM_ENUMSYMBOLS_CALLBACKW EnumSymbolsCallback, PVOID UserContext), FALSE);
#endif
		return pfnProc(hProcess, BaseOfDll, EnumSymbolsCallback, UserContext);
	}
	static BOOL SymEnumerateModules(HANDLE hProcess, PXSYM_ENUMMODULES_CALLBACK EnumModulesCallback, PVOID UserContext)
	{
#if defined(_IMAGEHLP64)
		PROC_LOAD(BOOL, SymEnumerateSymbols64, (HANDLE hProcess, PXSYM_ENUMMODULES_CALLBACK EnumModulesCallback, PVOID UserContext), FALSE);
#else
		PROC_LOAD(BOOL, SymEnumerateSymbols, (HANDLE hProcess, PXSYM_ENUMMODULES_CALLBACK EnumModulesCallback, PVOID UserContext), FALSE);
#endif
		return pfnProc(hProcess, EnumModulesCallback, UserContext);
	}
	static BOOL StackWalk(DWORD MachineType, HANDLE hProcess, HANDLE hThread, LPSTACKFRAME StackFrame, PVOID ContextRecord
		, PREAD_PROCESS_MEMORY_ROUTINE ReadMemoryRoutine, PFUNCTION_TABLE_ACCESS_ROUTINE FunctionTableAccessRoutine
		, PGET_MODULE_BASE_ROUTINE GetModuleBaseRoutine, PTRANSLATE_ADDRESS_ROUTINE TranslateAddress)
	{
		PROC_LOAD(BOOL, StackWalk, (DWORD MachineType, HANDLE hProcess, HANDLE hThread, LPSTACKFRAME StackFrame, PVOID ContextRecord
		, PREAD_PROCESS_MEMORY_ROUTINE ReadMemoryRoutine, PFUNCTION_TABLE_ACCESS_ROUTINE FunctionTableAccessRoutine
		, PGET_MODULE_BASE_ROUTINE GetModuleBaseRoutine, PTRANSLATE_ADDRESS_ROUTINE TranslateAddress)
		, FALSE);
		return pfnProc(MachineType, hProcess, hThread, StackFrame, ContextRecord
			, ReadMemoryRoutine, FunctionTableAccessRoutine, GetModuleBaseRoutine, TranslateAddress);
	}
	static PVOID ImageDirectoryEntryToData(PVOID Base, BOOLEAN MappedAsImage, USHORT DirectoryEntry, PULONG Size)
	{
		PROC_LOAD(PVOID, ImageDirectoryEntryToData, (PVOID Base, BOOLEAN MappedAsImage, USHORT DirectoryEntry, PULONG Size), NULL);
		return pfnProc(Base, MappedAsImage, DirectoryEntry, Size);
	}
	/**
	 * @}
	*/

#undef PROC_LOAD

public:
	// AhX擾
	template<typename F, typename CHARTYPE_>
	static F	GetProcAddress(const CHARTYPE_ * lpProcName)
	{
IRIS_MSC_PRAGMA_WARNING_BEGIN()
IRIS_MSC_PRAGMA_WARNING_DISABLE(4191)	// PROC  hoge ւ̕ϊ͕ۏ؂܂B
		return reinterpret_cast<F>(GetInstance().m_Module.GetProcAddress(lpProcName));
IRIS_MSC_PRAGMA_WARNING_END()
	}
};

}	// end of namespace wx
}	// end of namespace iris

#endif
