//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXMAvifil.h
 * @brief		Avifil t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXMAvifil_H_2BBF4EF9_C138_4581_8C17_D8045CCE24DA
#define INCG_IRIS_WXMAvifil_H_2BBF4EF9_C138_4581_8C17_D8045CCE24DA

//======================================================================
// include
#include "../WXModule.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/**
 * @brief	Avifil NX
*/
class CAvifil : private INonCopyable<CAvifil>
{
	CModule m_Module;
private:
	// RXgN^
	CAvifil(void)		{ Load(); }

	// CX^X̎擾
	static	CAvifil&	GetInstance(void)	{ static CAvifil Avifil; return Avifil; }
	// W[̃[h
	BOOL	Load(void)
	{
		if( m_Module.IsValid() ) return TRUE;
		return m_Module.Load(IRIS_TEXT("avifil32.dll"));
	}
	// W[̃A[h
	BOOL	Unload(void)
	{
		return m_Module.Release();
	}

#define PROC_LOAD(_ret, _name, _args, _err)			\
	typedef _ret (__stdcall *pfn##_name)##_args;	\
	static pfn##_name	pfnProc = nullptr;			\
	do {											\
	if( pfnProc == nullptr ) {						\
		if( !GetInstance().Load() ) return _err;	\
		pfnProc = GetProcAddress<pfn##_name>(#_name);	\
		if( pfnProc == nullptr ) return _err;		\
	} } while(0)

public:
	/**
	 * @name	wrap
	 * @{
	*/
	static void AVIFileInit(void)
	{
		PROC_LOAD(void, AVIFileInit, (void), );
		pfnProc();
	}
	static void AVIFileExit(void)
	{
		PROC_LOAD(void, AVIFileExit, (void), );
		pfnProc();
	}
	static ULONG AVIFileAddRef(PAVIFILE pfile)
	{
		PROC_LOAD(ULONG, AVIFileAddRef, (PAVIFILE pfile), 0);
		return pfnProc(pfile);
	}
	static HRESULT AVIFileOpenA(PAVIFILE FAR * ppfile, LPCSTR szFile, UINT uMode, LPCLSID lpHandler)
	{
		PROC_LOAD(HRESULT, AVIFileOpenA, (PAVIFILE FAR * ppfile, LPCSTR szFile, UINT uMode, LPCLSID lpHandler), ERROR_INVALID_FUNCTION);
		return pfnProc(ppfile, szFile, uMode, lpHandler);
	}
	static HRESULT AVIFileOpenW(PAVIFILE FAR * ppfile, LPCWSTR szFile, UINT uMode, LPCLSID lpHandler)
	{
		PROC_LOAD(HRESULT, AVIFileOpenW, (PAVIFILE FAR * ppfile, LPCWSTR szFile, UINT uMode, LPCLSID lpHandler), ERROR_INVALID_FUNCTION);
		return pfnProc(ppfile, szFile, uMode, lpHandler);
	}
	static HRESULT AVIFileInfoA(PAVIFILE pfile, LPAVIFILEINFOA pfi, LONG lSize)
	{
		PROC_LOAD(HRESULT, AVIFileInfoA, (PAVIFILE pfile, LPAVIFILEINFOA pfi, LONG lSize), ERROR_INVALID_FUNCTION);
		return pfnProc(pfile, pfi, lSize);
	}
	static HRESULT AVIFileInfoW(PAVIFILE pfile, LPAVIFILEINFOW pfi, LONG lSize)
	{
		PROC_LOAD(HRESULT, AVIFileInfoW, (PAVIFILE pfile, LPAVIFILEINFOW pfi, LONG lSize), ERROR_INVALID_FUNCTION);
		return pfnProc(pfile, pfi, lSize);
	}
	static HRESULT AVIFileGetStream(PAVIFILE pfile, PAVISTREAM FAR * ppavi, DWORD fccType, LONG lParam)
	{
		PROC_LOAD(HRESULT, AVIFileGetStream, (PAVIFILE pfile, PAVISTREAM FAR * ppavi, DWORD fccType, LONG lParam), ERROR_INVALID_FUNCTION);
		return pfnProc(pfile, ppavi, fccType, lParam);
	}
	static ULONG AVIFileRelease(PAVIFILE pfile)
	{
		PROC_LOAD(ULONG, AVIFileRelease, (PAVIFILE pfile), 0);
		return pfnProc(pfile);
	}

	static HRESULT AVIStreamOpenFromFileA(PAVISTREAM FAR * ppavi, LPCSTR szFile, DWORD fccType, LONG lParam, UINT uMode, CLSID FAR *lpHandler)
	{
		PROC_LOAD(HRESULT, AVIStreamOpenFromFileA, (PAVISTREAM FAR * ppavi, LPCSTR szFile, DWORD fccType, LONG lParam, UINT uMode, CLSID FAR *lpHandler), ERROR_INVALID_FUNCTION);
		return pfnProc(ppavi, szFile, fccType, lParam, uMode, lpHandler);
	}
	static HRESULT AVIStreamOpenFromFileW(PAVISTREAM FAR * ppavi, LPCWSTR szFile, DWORD fccType, LONG lParam, UINT uMode, CLSID FAR *lpHandler)
	{
		PROC_LOAD(HRESULT, AVIStreamOpenFromFileW, (PAVISTREAM FAR * ppavi, LPCWSTR szFile, DWORD fccType, LONG lParam, UINT uMode, CLSID FAR *lpHandler), ERROR_INVALID_FUNCTION);
		return pfnProc(ppavi, szFile, fccType, lParam, uMode, lpHandler);
	}
	static ULONG AVIStreamAddRef(PAVISTREAM pavi)
	{
		PROC_LOAD(ULONG, AVIStreamAddRef, (PAVISTREAM pavi), 0);
		return pfnProc(pavi);
	}
	static ULONG AVIStreamRelease(PAVISTREAM pavi)
	{
		PROC_LOAD(ULONG, AVIStreamRelease, (PAVISTREAM pavi), 0);
		return pfnProc(pavi);
	}
	static HRESULT AVIStreamInfoW(PAVISTREAM pavi, LPAVISTREAMINFOW psi, LONG lSize)
	{
		PROC_LOAD(HRESULT, AVIStreamInfoW, (PAVISTREAM pavi, LPAVISTREAMINFOW psi, LONG lSize), ERROR_INVALID_FUNCTION);
		return pfnProc(pavi, psi, lSize);
	}
	static HRESULT AVIStreamInfoA(PAVISTREAM pavi, LPAVISTREAMINFOA psi, LONG lSize)
	{
		PROC_LOAD(HRESULT, AVIStreamInfoA, (PAVISTREAM pavi, LPAVISTREAMINFOA psi, LONG lSize), ERROR_INVALID_FUNCTION);
		return pfnProc(pavi, psi, lSize);
	}
	static HRESULT AVIStreamReadFormat(PAVISTREAM pavi, LONG lPos, LPVOID lpFormat, LONG FAR *lpcbFormat)
	{
		PROC_LOAD(HRESULT, AVIStreamReadFormat, (PAVISTREAM pavi, LONG lPos, LPVOID lpFormat, LONG FAR *lpcbFormat), ERROR_INVALID_FUNCTION);
		return pfnProc(pavi, lPos, lpFormat, lpcbFormat);
	}
	static HRESULT AVIStreamRead(PAVISTREAM pavi, LONG lStart, LONG lSamples, LPVOID lpBuffer, LONG cbBuffer, LONG FAR * plBytes, LONG FAR * plSamples)
	{
		PROC_LOAD(HRESULT, AVIStreamRead, (PAVISTREAM pavi, LONG lStart, LONG lSamples, LPVOID lpBuffer, LONG cbBuffer, LONG FAR * plBytes, LONG FAR * plSamples), ERROR_INVALID_FUNCTION);
		return pfnProc(pavi, lStart, lSamples, lpBuffer, cbBuffer, plBytes, plSamples);
	}
	static LONG AVIStreamLength(PAVISTREAM pavi)
	{
		PROC_LOAD(LONG, AVIStreamLength, (PAVISTREAM pavi), 0);
		return pfnProc(pavi);
	}
	static LONG AVIStreamStart(PAVISTREAM pavi)
	{
		PROC_LOAD(LONG, AVIStreamStart, (PAVISTREAM pavi), 0);
		return pfnProc(pavi);
	}
	static LONG AVIStreamTimeToSample(PAVISTREAM pavi, LONG lTime)
	{
		PROC_LOAD(LONG, AVIStreamTimeToSample, (PAVISTREAM pavi, LONG lTime), 0);
		return pfnProc(pavi, lTime);
	}
	static LONG AVIStreamSampleToTime(PAVISTREAM pavi, LONG lSample)
	{
		PROC_LOAD(LONG, AVIStreamSampleToTime, (PAVISTREAM pavi, LONG lSample), 0);
		return pfnProc(pavi, lSample);
	}

	static HRESULT AVIMakeStreamFromClipboard(UINT cfFormat, HANDLE hGlobal, PAVISTREAM FAR *ppstream)
	{
		PROC_LOAD(HRESULT, AVIMakeStreamFromClipboard, (UINT cfFormat, HANDLE hGlobal, PAVISTREAM FAR *ppstream), ERROR_INVALID_FUNCTION);
		return pfnProc(cfFormat, hGlobal, ppstream);
	}

	static HRESULT AVIMakeCompressedStream(PAVISTREAM FAR * ppsCompressed, PAVISTREAM ppsSource, AVICOMPRESSOPTIONS FAR *lpOptions, CLSID FAR *pclsidHandler)
	{
		PROC_LOAD(HRESULT, AVIMakeCompressedStream, (PAVISTREAM FAR * ppsCompressed, PAVISTREAM ppsSource, AVICOMPRESSOPTIONS FAR *lpOptions, CLSID FAR *pclsidHandler), ERROR_INVALID_FUNCTION);
		return pfnProc(ppsCompressed, ppsSource, lpOptions, pclsidHandler);
	}


	static PGETFRAME AVIStreamGetFrameOpen(PAVISTREAM pavi, LPBITMAPINFOHEADER lpbiWanted)
	{
		PROC_LOAD(PGETFRAME, AVIStreamGetFrameOpen, (PAVISTREAM pavi, LPBITMAPINFOHEADER lpbiWanted), nullptr);
		return pfnProc(pavi, lpbiWanted);
	}
	static LPVOID AVIStreamGetFrame(PGETFRAME pg, LONG lPos)
	{
		PROC_LOAD(LPVOID, AVIStreamGetFrame, (PGETFRAME pg, LONG lPos), nullptr);
		return pfnProc(pg, lPos);
	}
	static HRESULT AVIStreamGetFrameClose(PGETFRAME pg)
	{
		PROC_LOAD(HRESULT, AVIStreamGetFrameClose, (PGETFRAME pg), ERROR_INVALID_FUNCTION);
		return pfnProc(pg);
	}

	/**
	* @}
	*/

#undef PROC_LOAD

public:
	// AhX擾
	template<typename F, typename CHARTYPE_>
	static F	GetProcAddress(const CHARTYPE_ * lpProcName)
	{
IRIS_MSC_PRAGMA_WARNING_BEGIN()
IRIS_MSC_PRAGMA_WARNING_DISABLE(4191)	// PROC  hoge ւ̕ϊ͕ۏ؂܂B
		return reinterpret_cast<F>(GetInstance().m_Module.GetProcAddress(lpProcName));
IRIS_MSC_PRAGMA_WARNING_END()
	}
};

}	// end of namespace wx
}	// end of namespace iris

#endif
