//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXSystemParametersInfo.h
 * @brief		SystemParametersInfo t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXSystemParametersInfo_H_
#define INCG_IRIS_WXSystemParametersInfo_H_

//======================================================================
// include
#include "iris_object.h"

namespace iris {
namespace wx
{

//======================================================================
// declare
template<typename CHARTYPE_>class CTSystemParameters;

//======================================================================
// typedef
typedef CTSystemParameters<CHAR>	CSystemParametersA;
typedef CTSystemParameters<WCHAR>	CSystemParametersW;
typedef CTSystemParameters<TCHAR>	CSystemParameters;

//======================================================================
// class
/// SystemParametersInfo NX
template<typename CHARTYPE_>
class CTSystemParameters : public IIrisObject
{
public:
	// ̎擾Ɛݒ
	static BOOL Information(UINT uAction, UINT uParam, PVOID pParam, UINT ufWinIni);
};

/// SystemParametersInfo fXNgbv NX
class CSPIDesktop : public IIrisObject
{
public:
	/**
	 * @brief	ǎ̃pX擾
	*/
	template<typename CHARTYPE_>
	static BOOL GetWallpaper(CHARTYPE_* lpszPath, UINT uLength)
	{
		return CTSystemParameters<CHARTYPE_>::Information(SPI_GETDESKWALLPAPER, uLength, lpszPath, 0);
	}

	/**
	 * @brief	ǎݒ
	*/
	template<typename CHARTYPE_>
	static BOOL SetWallpaper(CHARTYPE_* lpszPath, UINT ufWinInit=SPIF_UPDATEINIFILE|SPIF_SENDCHANGE)
	{
		return CTSystemParameters<CHARTYPE_>::Information(SPI_SETDESKWALLPAPER, 0, lpszPath, ufWinInit);
	}

	// vC}j^̍Ɨ̈̎擾
	static BOOL GetWorkArea(LPRECT lprc);

	// VXeJ[\[h
	static BOOL ReloadSystemCursor(UINT ufWinInit=SPIF_UPDATEINIFILE|SPIF_SENDCHANGE);
};

}	// end of namespace wx
}	// end of namespace iris

#endif
