//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXSystemParametersInfo.cpp
 * @brief		SystemParametersInfo t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXSystemParametersInfo_CPP_

//======================================================================
// include
#include "WXSystemParametersInfo.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * f[^̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	uAction		= ANV(SPI_***)
 * @param [in]	uParam		=
 * @param [io]	pParam		=
 * @param [in]	ufWinIni	= [U[vt@C̍XVIvV
 * @return	
*//***********************************************************************/
template<>
BOOL CTSystemParameters<CHAR>::Information(UINT uAction, UINT uParam, PVOID pParam, UINT ufWinIni)
{
	return SystemParametersInfoA(uAction, uParam, pParam, ufWinIni);
}
template<>
BOOL CTSystemParameters<WCHAR>::Information(UINT uAction, UINT uParam, PVOID pParam, UINT ufWinIni)
{
	return SystemParametersInfoW(uAction, uParam, pParam, ufWinIni);
}

// CSPIDesktop
/**********************************************************************//**
 *
 * vC}j^̍Ɨ̈̎擾
 *
 ----------------------------------------------------------------------
 * @param [out]	lprc	= o̓obt@
 * @return	
*//***********************************************************************/
BOOL CSPIDesktop::GetWorkArea(LPRECT lprc)
{
	return CSystemParameters::Information(SPI_GETWORKAREA, 0, lprc, 0);
}

/**********************************************************************//**
 *
 * VXeJ[\[h
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CSPIDesktop::ReloadSystemCursor(UINT ufWinInit)
{
	return CSystemParameters::Information(SPI_SETCURSORS, 0, 0, ufWinInit);
}

}	// end of namespace wx
}	// end of namespace iris

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "../../../../../unit/UnitCore.h"
#include "../../../../../iris_using.h"
#include "../../../../../iris_iostream.h"

//======================================================================
// test
IRIS_UNITTEST(CWXSPIDesktop, WorkArea)
{
	RECT rc;
	ASSERT_TRUE( CSPIDesktop::GetWorkArea(&rc) );

	std::cout << "left  =" << rc.left	<< std::endl;
	std::cout << "top   =" << rc.top	<< std::endl;
	std::cout << "right =" << rc.right	<< std::endl;
	std::cout << "bottom=" << rc.bottom	<< std::endl;
}

#endif
