//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXSystemInfo.cpp
 * @brief		WXSystemInfo t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXSystemInfo_CPP_

//======================================================================
// include
#include "WXSystemInfo.h"
#include "../modules/WXMKernel.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CSystemInfo::CSystemInfo(void)
{
	if( !CKernel::GetNativeSystemInfo(&m_Info) )
	{
		GetSystemInfo(&m_Info);
	}
}

/**********************************************************************//**
 *
 * 64bit OS ǂ
 *
 -----------------------------------------------------------------------
 * @return ^Ul
*//***********************************************************************/
bool CSystemInfo::Is64bitOS(void) const
{
	switch(m_Info.wProcessorArchitecture)
	{
	case PROCESSOR_ARCHITECTURE_AMD64:
	case PROCESSOR_ARCHITECTURE_IA64:
		return true;
	}
	return false;
}

/**********************************************************************//**
 *
 * 64bit OS ǂ
 *
 -----------------------------------------------------------------------
 * @return ^Ul
*//***********************************************************************/
bool CSystemInfo::Is32bitOS(void) const
{
	switch(m_Info.wProcessorArchitecture)
	{
	case PROCESSOR_ARCHITECTURE_INTEL:
		return true;
	}
	return false;
}

}	// end of namespace wx
}	// end of namespace iris
