//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXOSVersion.h
 * @brief		OS Version t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXOSVersion_H_
#define INCG_IRIS_WXOSVersion_H_

//======================================================================
// include
#include "iris_object.h"
#include "c++0x/cpp0x_type_traits.hpp"

namespace iris {
namespace wx
{

//======================================================================
// declare
template<typename CHARTYPE_>class CTOSVersionInfo;

//======================================================================
// typedef
typedef CTOSVersionInfo<CHAR>	COSVersionInfoA;
typedef CTOSVersionInfo<WCHAR>	COSVersionInfoW;
typedef CTOSVersionInfo<TCHAR>	COSVersionInfo;

//======================================================================
// class
/// o[WNX
template<typename CHARTYPE_>
class CTOSVersionInfo : public IIrisObject
{
	typedef CHARTYPE_	_Mychar;
	typedef CHARTYPE_	*_Mylpstr;
public:
	typedef typename iml::type_select< (cpp0x::is_same<CHARTYPE_, WCHAR>::value), OSVERSIONINFOW, OSVERSIONINFOA >::type OSVI;
	typedef OSVI			*LPOSVI;
#if	!defined(IRIS_WIN32_WCE)
	typedef typename iml::type_select< (cpp0x::is_same<CHARTYPE_, WCHAR>::value), OSVERSIONINFOEXW, OSVERSIONINFOEXA >::type OSVIEX;
	typedef OSVIEX			*LPOSVIEX;
	typedef OSVIEX			_Myosvi;
#else
	typedef OSVI			_Myosvi;
#endif


private:
	_Myosvi		m_Osviex;	//!< o[W\
public:
	// RXgN^
	CTOSVersionInfo(void);

	bool				IsValid(void)	const	{ return m_Osviex.dwOSVersionInfoSize != 0; }
	bool				IsEx(void)		const	{ return m_Osviex.dwOSVersionInfoSize != sizeof(OSVI); }

public:
	// Windows NT n
	bool				IsWindowsNT(void) const;

public:
	bool				GetString(_Mylpstr lpString, DWORD dwLength) const;

public:
			_Myosvi&	GetOSVersionInfo(void)			{ return m_Osviex; }
	const	_Myosvi&	GetOSVersionInfo(void) const	{ return m_Osviex; }

	/**
	 * @name	operator
	 * @{
	*/
	operator		_Myosvi&	(void)				{ return m_Osviex; }
	operator const	_Myosvi&	(void)		const	{ return m_Osviex; }
			_Myosvi*	operator -> (void)			{ return &m_Osviex; }
	const	_Myosvi*	operator -> (void)	const	{ return &m_Osviex; }
	/**
	 * @}
	*/
};

}	// end of namespace wx
}	// end of namespace iris

#endif
