//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXEnvironmentStrings.cpp
 * @brief		EnvironmentStrings t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011-2012 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXEnvironmentStrings_CPP_

//======================================================================
// include
#include "WXEnvironmentStrings.h"

#if !defined(IRIS_WIN32_WCE)

namespace iris {
namespace wx
{

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
template<typename CHARTYPE_>
CTEnvironmentStrings<CHARTYPE_>::CTEnvironmentStrings(void)
: m_lpEnvStr(nullptr)
{
	Load();
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
template<typename CHARTYPE_>
CTEnvironmentStrings<CHARTYPE_>::~CTEnvironmentStrings(void)
{
	Unload();
}

/**********************************************************************//**
 *
 * ǂݍ
 *
 ----------------------------------------------------------------------
 * @return 
*//***********************************************************************/
template<>
BOOL CTEnvironmentStrings<CHAR>::Load(void)
{
	if( !Unload() ) return FALSE;
#if	defined(UNICODE) && defined(GetEnvironmentStrings)
#  undef GetEnvironmentStrings
#endif
	m_lpEnvStr = ::GetEnvironmentStrings();
	return TRUE;
}
template<>
BOOL CTEnvironmentStrings<WCHAR>::Load(void)
{
	if( !Unload() ) return FALSE;
	m_lpEnvStr = ::GetEnvironmentStringsW();
	return TRUE;
}


/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @return 
*//***********************************************************************/
template<>
BOOL CTEnvironmentStrings<CHAR>::Unload(void)
{
	if( m_lpEnvStr != nullptr )
	{
		if( !FreeEnvironmentStringsA(m_lpEnvStr) ) return FALSE;
		m_lpEnvStr = nullptr;
	}
	return TRUE;
}
template<>
BOOL CTEnvironmentStrings<WCHAR>::Unload(void)
{
	if( m_lpEnvStr != nullptr )
	{
		if( !FreeEnvironmentStringsW(m_lpEnvStr) ) return FALSE;
		m_lpEnvStr = nullptr;
	}
	return TRUE;
}

/**********************************************************************//**
 *
 * WJ
 *
 ----------------------------------------------------------------------
 * @param [in]	lpSrc	= WJ
 * @param [out]	lpDst	= o
 * @param [in]	nSize	= o̓obt@TCY
 * @return KvȃTCY
*//***********************************************************************/
template<>
DWORD CTEnvironmentStrings<CHAR>::Expand(_Mylpcstr lpSrc, _Mylpstr lpDst, DWORD nSize)
{
	//DWORD dwRequest = ::ExpandEnvironmentStringsA(lpSrc, nullptr, 0);
	//if( dwRequest > nSize ) return dwRequest;
	return ::ExpandEnvironmentStringsA(lpSrc, lpDst, nSize);
}
template<>
DWORD CTEnvironmentStrings<WCHAR>::Expand(_Mylpcstr lpSrc, _Mylpstr lpDst, DWORD nSize)
{
	//DWORD dwRequest = ::ExpandEnvironmentStringsW(lpSrc, nullptr, 0);
	//if( dwRequest > nSize ) return dwRequest;
	return ::ExpandEnvironmentStringsW(lpSrc, lpDst, nSize);
} 


template class CTEnvironmentStrings<CHAR>;
template class CTEnvironmentStrings<WCHAR>;

}	// end of namespace wx
}	// end of namespace iris

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "../../debug/unittest/WXDebugUnitTest.h"
#include "../../base/WXError.h"
#include "iris_tchar.h"
#include "iris_using.h"
#include "iris_iostream.h"

//======================================================================
// test
IRIS_UNITTEST(CWXEnvironmentStringsUnitTest, Func)
{
	TCHAR path[MAX_PATH];
	CEnvironmentStrings::Expand(IRIS_TEXT("%WINDIR%"), path, MAX_PATH);
	_putts(path);
}

IRIS_UNITTEST(CWXEnvironmentStringsUnitTest, Japanese)
{
	DWORD length = CEnvironmentStrings::Expand(IRIS_TEXT("%WINDIR%\\fXNgbv"), nullptr, 0);
	std::cout << length << std::endl;
}

IRIS_UNITTEST(CWXEnvironmentStringsUnitTest, LongLong)
{
	TCHAR path[0x20000];
	for( size_t i=0, n=elementof(path)-1; i<n; ++i )
	{
		path[i] = IRIS_TEXT('0') + i % 10;
	}
	path[elementof(path)-1] = IRIS_TEXT('\0');

	{
		DWORD length = CEnvironmentStrings::Expand(path, nullptr, 0);
		if( length == 0 )
		{
			CScopedLastError sle;
			CLastError le(sle);
			std::cout << le.ToString() << std::endl;
		}
		std::cout << length << std::endl;
	}
	{
		TCHAR dst[0x20000] = {0};
		DWORD length = CEnvironmentStrings::Expand(path, dst, elementof(path));
		_putts(dst);
		std::cout << std::endl << length << std::endl;
	}
}

#endif	// #if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))

#endif
