//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXWow.cpp
 * @brief		Wow t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXWow_CPP_

//======================================================================
// include
#include "modules/WXMKernel.h"
#include "WXWow.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CWow64::CScopedDisable::CScopedDisable(void)
: m_pOld(nullptr)
{
	DisableFsRedirection(&m_pOld);
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CWow64::CScopedDisable::~CScopedDisable(void)
{
	RevertFsRedirection(m_pOld);
}

/**********************************************************************//**
 *
 * IsWow64
 *
 ----------------------------------------------------------------------
 * @return	^Ul
*//***********************************************************************/
BOOL CWow64::IsWow64(HANDLE hProcess)
{
	BOOL bIsWow64 = FALSE;
	if( !CKernel::IsWow64Process(hProcess, &bIsWow64) ) return FALSE;
	return bIsWow64;
}

/**********************************************************************//**
 *
 * Wow64on
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOLEAN CWow64::EnableFsRedirection(BOOLEAN Wow64FsEnableRedirection)
{
	return CKernel::Wow64EnableWow64FsRedirection(Wow64FsEnableRedirection);
}

/**********************************************************************//**
 *
 * Wow64off
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOLEAN CWow64::DisableFsRedirection(PVOID *OldValue)
{
	return CKernel::Wow64DisableWow64FsRedirection(OldValue);
}

/**********************************************************************//**
 *
 * Wow64߂
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOLEAN CWow64::RevertFsRedirection(PVOID OldValue)
{
	return CKernel::Wow64RevertWow64FsRedirection(OldValue);
}

}	// end of namespace wx
}	// end of namespace iris
