//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXTick.cpp
 * @brief		Tick ֌Wt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXTick_CPP_

//======================================================================
// include
#include "WXTick.h"

#define TICK_USE_REGISTRY
#ifdef TICK_USE_REGISTRY
#  include "../registry/WXRegistry.h"
#endif

namespace iris {
namespace wx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * Tick 擾
 *
*//***********************************************************************/
u64 CTick::GetTick(void)
{
	LARGE_INTEGER cnt;
	QueryPerformanceCounter(&cnt);
	return cnt.QuadPart;
}

/**********************************************************************//**
 *
 * 1b Tick 擾
 *
*//***********************************************************************/
u64 CTick::GetTickPerSecond(void)
{
	static u64 persec = 0;
	if( persec != 0 ) return persec;

#ifdef TICK_USE_REGISTRY
	CRegistry reg;
	if( reg.OpenEx(HKEY_LOCAL_MACHINE, "HARDWARE\\DESCRIPTION\\System\\CentralProcessor\\0", 0, KEY_READ) )
	{
		do
		{
			LPBYTE data;
			DWORD len = sizeof(data);
			if( !reg.QueryValueEx("~MHz", nullptr, pointer_cast<LPBYTE>(&data), &len) )
			{
				if( !reg.QueryValueEx("~Mhz", nullptr, pointer_cast<LPBYTE>(&data), &len) )
				{
					if( !reg.QueryValueEx("~mhz", nullptr, pointer_cast<LPBYTE>(&data), &len) )
					{
						break;
					}
				}
			}
			persec = static_cast<u64>(reinterpret_cast<u32>(data) * 1000000);
			return persec;
		} while(0);
	}
#endif
	LARGE_INTEGER freq;
	QueryPerformanceFrequency(&freq);
	persec = freq.QuadPart;
	return persec;
}

}	// end of namespace wx
}	// end of namespace iris
