//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXThread.cpp
 * @brief		Xbht@C
 *
 * @author		t.sirayanagi
 * @version		1.1
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================

//======================================================================
// include
#include "WXThread.h"
#include "../../../../iris_debug.h"

namespace iris {
namespace wx
{

//======================================================================
// class

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CThread::CThread(void)
: m_dwThreadId(0)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CThread::~CThread(void)
{
	Stop();
}

/**********************************************************************//**
 *
 * XbhJ
 *
 -----------------------------------------------------------------------
 * @param [in]	dwDesiredAccess	= ANZX(THREAD_*** or SYNCHRONIZE)
 * @param [in]	bInheritHandle	= VvZXɌp邩ǂ
 * @param [in]	dwThreadId		= XbhID
 * @return	
*//***********************************************************************/
#if	!defined(IRIS_WIN32_WCE)
bool CThread::Open(DWORD dwDesiredAccess, BOOL bInheritHandle, DWORD dwThreadId)
{
	HANDLE hThread = ::OpenThread(dwDesiredAccess, bInheritHandle, dwThreadId);
	if( hThread == nullptr )	return false;
	if( !TryAttach(hThread) )	return false;
	m_dwThreadId = dwThreadId;
	return true;
}
#endif

/**********************************************************************//**
 *
 * Xbh쐬
 *
 -----------------------------------------------------------------------
 * @param [in]	pStart				= Jn[`
 * @param [in]	lpArgs				= [U[
 * @param [in]	dwStackSize			= X^bNTCY
 * @param [in]	lpThreadAttributes	= Xbh̃ZLeBʎq(NULL)
 * @return	
*//***********************************************************************/
bool CThread::Create(LPTHREAD_START_ROUTINE pStart, LPVOID lpArgs
					 , DWORD dwStackSize, LPSECURITY_ATTRIBUTES lpThreadAttributes)
{
	return Create((PROC)pStart, lpArgs, dwStackSize, lpThreadAttributes);
}
bool CThread::Create(PROC pStart, LPVOID lpArgs
					 , DWORD dwStackSize, LPSECURITY_ATTRIBUTES lpThreadAttributes)
{
	Close();
	const int priority = ::GetThreadPriority( ::GetCurrentThread() );
	const bool bOverride = ( priority != THREAD_PRIORITY_NORMAL );
	HANDLE hThread = _CreateThread(pStart, lpArgs, dwStackSize, lpThreadAttributes);
	if( hThread == nullptr )	return false;
	if( !TryAttach(hThread) )	return false;
	if( bOverride != false )
	{
		::SetThreadPriority(hThread, priority);
	}
	return true;
}

#if	!defined(IRIS_WIN32_WCE)
/**********************************************************************//**
 *
 * ʂ̃vZX̃AhXԂŉғXbh쐬
 *
 -----------------------------------------------------------------------
 * @param [in]	hProcess			= Xbh쐬vZX
 * @param [in]	pStart				= Jn[`
 * @param [in]	lpArgs				= [U[
 * @param [in]	dwStackSize			= X^bNTCY
 * @param [in]	lpThreadAttributes	= Xbh̃ZLeBʎq(NULL)
 * @return	
*//***********************************************************************/
bool CThread::CreateRemote(HANDLE hProcess, LPTHREAD_START_ROUTINE pStart, LPVOID lpArgs
						   , DWORD dwStackSize, LPSECURITY_ATTRIBUTES lpThreadAttributes)
{
	Close();
	const int priority = ::GetThreadPriority( ::GetCurrentThread() );
	const bool bOverride = ( priority != THREAD_PRIORITY_NORMAL );
	HANDLE hThread = ::CreateRemoteThread( hProcess, lpThreadAttributes, dwStackSize
		, pStart, lpArgs, CREATE_SUSPENDED , &m_dwThreadId );
	if( hThread == nullptr )	return false;
	if( !TryAttach(hThread) )	return false;
	if( bOverride != false )
	{
		::SetThreadPriority(hThread, priority);
	}
	return true;
}
bool CThread::CreateRemote(HANDLE hProcess, PROC pStart, LPVOID lpArgs
						   , DWORD dwStackSize, LPSECURITY_ATTRIBUTES lpThreadAttributes)
{
	return CreateRemote(hProcess, (LPTHREAD_START_ROUTINE)pStart, lpArgs, dwStackSize, lpThreadAttributes);
}
#endif

/**********************************************************************//**
 *
 * Xbh쐬Ăs
 *
 -----------------------------------------------------------------------
 * @param [in]	pStart	= Jn[`
 * @param [in]	lpArgs	= [U[
 * @param [in]	dwStackSize	= X^bNTCY
 * @return	
*//***********************************************************************/
bool CThread::CreateStart(LPTHREAD_START_ROUTINE pStart, LPVOID lpArgs
						  , DWORD dwStackSize, LPSECURITY_ATTRIBUTES lpThreadAttributes)
{
	return CreateStart((PROC)pStart, lpArgs, dwStackSize, lpThreadAttributes);
}
bool CThread::CreateStart(PROC pStart, LPVOID lpArgs
						  , DWORD dwStackSize, LPSECURITY_ATTRIBUTES lpThreadAttributes)
{
	if( !Create(pStart, lpArgs, dwStackSize, lpThreadAttributes) ) return false;
	Start();
	return true;
}

/**********************************************************************//**
 *
 * XbhJn
 *
*//***********************************************************************/
void CThread::Start(void)
{
	Resume();
}

/**********************************************************************//**
 *
 * XbhI
 *
*//***********************************************************************/
void CThread::Stop(void)
{
	Close();
}

/**********************************************************************//**
 *
 * JgXbhI
 *
 -----------------------------------------------------------------------
 * @param [in]	dwExitCode	= IR[h
*//***********************************************************************/
void CThread::Exit(DWORD dwExitCode)
{
	ExitThread(dwExitCode);
}

/**********************************************************************//**
 *
 * Xbh̏I҂
 *
 -----------------------------------------------------------------------
 * @return	IR[h
*//***********************************************************************/
DWORD CThread::Wait(void)
{
	DWORD dwExitCode = 0;
	if( IsActive() != false )
	{
		HANDLE hThread = Detach();
#if 0
		while(1)
		{
			if( ::WaitForSingleObject(hThread, 1000) == WAIT_TIMEOUT )
			{
				::GetExitCodeThread(hThread, &dwExitCode);
				if( dwExitCode != STILL_ACTIVE ) break;
			}
		}
#else
		::WaitForSingleObject(hThread, INFINITE);
#endif
		::CloseHandle(hThread);
		m_dwThreadId = 0;
	}
	return dwExitCode;
}

/**********************************************************************//**
 *
 * sǂ擾
 *
 -----------------------------------------------------------------------
 * @retval	true :s
 * @retval	false:sĂȂ
*//***********************************************************************/
bool CThread::IsActive(void) const
{
	DWORD dwExitCode;
	if( m_hObject == nullptr ) return false;
	if( !::GetExitCodeThread(m_hObject, &dwExitCode) ) return false;
	return dwExitCode == STILL_ACTIVE;
}

/**********************************************************************//**
 *
 * Xbhҋ@Ԃɂ
 *
 -----------------------------------------------------------------------
 * @return	֐ĂяoÕTXyhJEg
 * @retval	-1 = s
*//***********************************************************************/
DWORD CThread::Suspend(void)
{
	return ::SuspendThread(m_hObject);
}

/**********************************************************************//**
 *
 * ҋ@Ԃ̃Xbh𕜋A
 *
 -----------------------------------------------------------------------
 * @return	TXyhJEg
 * @retval	-1 = s
*//***********************************************************************/
DWORD CThread::Resume(void)
{
	return ::ResumeThread(m_hObject);
}

/**********************************************************************//**
 *
 * ҋ@Ԃ̃XbhJn
 *
 -----------------------------------------------------------------------
 * @return 
*//***********************************************************************/
BOOL CThread::Wakeup(void)
{
	if( IsActive() ) return TRUE;
	DWORD cnt = 0;
	do
	{
		cnt = Resume();
		if( cnt == -1 ) return FALSE;
	} while(cnt);

	return TRUE;
}

/**********************************************************************//**
 *
 * XbhI
 *
 -----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CThread::Terminate(void)
{
	DWORD dwExitCode = 0;
	::GetExitCodeThread(m_hObject, &dwExitCode);
	return ::TerminateThread(m_hObject, dwExitCode);
}

/**********************************************************************//**
 *
 * Xbh̗D揇ʂύX
 *
 -----------------------------------------------------------------------
 * @param	Priority	= D揇
 * @return	
*//***********************************************************************/
BOOL CThread::SetPriority(int Priority)
{
	return ::SetThreadPriority(m_hObject, Priority);
}

/**********************************************************************//**
 *
 * Xbh̗D揇ʂ擾
 *
 -----------------------------------------------------------------------
 * @return	D揇
*//***********************************************************************/
int CThread::GetPriority(void) const
{
	return ::GetThreadPriority(m_hObject);
}

/**********************************************************************//**
 *
 * vCIeBu[Xg̏Ԃ擾
 *
 -----------------------------------------------------------------------
 * @param [out]	pDisablePriorityBoost	= o
 * @return	
*//***********************************************************************/
#if	!defined(IRIS_WIN32_WCE)
BOOL CThread::GetPriorityBoost(LPBOOL pDisablePriorityBoost)
{
	return ::GetThreadPriorityBoost(m_hObject, pDisablePriorityBoost);
}
#endif

/**********************************************************************//**
 *
 * XbhReLXg擾
 *
 -----------------------------------------------------------------------
 * @return	D揇
*//***********************************************************************/
BOOL CThread::GetContext(LPCONTEXT lpContext) const
{
	return ::GetThreadContext(m_hObject, lpContext);
}

/**********************************************************************//**
 *
 * XbhɃbZ[W̑M
 *
 -----------------------------------------------------------------------
 * @param	uMsg	= s郁bZ[W
 * @param	wParam	= s郁bZ[W@
 * @param	lParam	= s郁bZ[WA
 * @return	
*//***********************************************************************/
BOOL CThread::PostMessageA(UINT uMsg, WPARAM wParam, LPARAM lParam)
{
#if !defined(IRIS_WIN32_WCE)
	return ::PostThreadMessageA(m_dwThreadId, uMsg, wParam, lParam);
#else
	return FALSE;
#endif
}
/// CThread::PostMessageA Q
BOOL CThread::PostMessageW(UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	return ::PostThreadMessageW(m_dwThreadId, uMsg, wParam, lParam);
}

/**********************************************************************//**
 *
 * Xbh쐬
 *
 -----------------------------------------------------------------------
 * @param [in]	pfnEntry	= Gg֐|C^
 * @param [in]	lpArgs		= Xbhɓn
 * @param [in]	dwStackSize	= X^bNTCY
 * @param [in]	lpSecurity	= ZLeBLqq
 * @return nh
*//***********************************************************************/
HANDLE CThread::_CreateThread(PROC pfnEntry, LPVOID lpArgs, DWORD dwStackSize, void* lpSecurity)
{
	return ::CreateThread( static_cast<LPSECURITY_ATTRIBUTES>(lpSecurity), dwStackSize
		, reinterpret_cast<LPTHREAD_START_ROUTINE>(pfnEntry), lpArgs, CREATE_SUSPENDED , &m_dwThreadId );
}


}	// end of namespace wx
}	// end of namespace iris
