//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXPfmTimer.h
 * @brief		Performance^C}[NXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXPfmTimer_H_
#define INCG_IRIS_WXPfmTimer_H_

//======================================================================
// include
#include "fnd/system/FndTimer.h"

namespace iris {
namespace wx
{

//======================================================================
// class
//! ԂǗNX
class CPfmTimer : public fnd::ITimer
{
private:
	LARGE_INTEGER	m_Freq;		//!< g
public:
	// RXgN^
	CPfmTimer(void);
	// fXgN^
	~CPfmTimer(void);

protected:
	// ݂̃^C}[JEg擾
	u64		GetNowTime(void)	const;

public:
	// EZbg
	void	Reset(void);

public:
	// oߎԂ̎擾
	// out : oߎ
	u64		GetElapsedMilliSecond(void)	const;
	// AvP[VԂ̎擾
	// out : NĂ̎
	u64		GetStockMilliSecond(void)	const;

public:
	// GetSecond
	u64		GetElapsedMilliSecondRef(void)	const;
	// Sync(XVԂASPFɂȂ悤Sync)
	bool	Sync(bool sleep);
	// Sync̍XVԂ̎擾
	float	GetSyncElapsedSecond(void)	const;

public:
	// p\ǂ
	static bool	IsSupported(void);
};

}	// end of namespace wx
}	// end of namespace iris

#endif
