//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXCriticalSection.h
 * @brief		NeBJZNV t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2012 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXCriticalSection_H_
#define INCG_IRIS_WXCriticalSection_H_

//======================================================================
// include
#include "../../../../fnd/types/FndSyncObject.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/// NeBJZNVNX
class CCriticalSection : public fnd::ISyncObject
{
	CRITICAL_SECTION	m_Section;	//!< NeBJZNV

public:
	// RXgN^
	CCriticalSection(void);
	// fXgN^
	virtual ~CCriticalSection(void);

public:
	/// bN擾
	virtual bool	Lock(void);
	virtual bool	Lock(u32 /*uTimeout*/)	{ return Lock(); }
	/// bN
	virtual void	Unlock(void);
	/// bN擾
	virtual bool	TryLock(void);

public:
	/// NeBJZNV\̂̎擾
	const CRITICAL_SECTION&	GetCriticalSection(void)	const { return m_Section; }
};

}	// end of namespace wx
}	// end of namespace iris

#endif
