//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXMMWaveFile.cpp
 * @brief		Wavet@Ct@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXMMWaveFile_CPP_

//======================================================================
// include
#include "WXMMWaveFile.h"
#include "WXMMSysError.h"
#include "../wx_inchead.h"

#if	!defined(IRIS_WIN32_WCE) || defined(__IRIS_WCEWRAP_MMSYSTEM)

//======================================================================
// link
#if defined(IRIS_MSC)
#  if	!defined(IRIS_WIN32_WCE)
#pragma comment( lib, "winmm.lib" )
#  endif
#endif

namespace iris {
namespace wx
{

//======================================================================
// class

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CMMWaveFile::CMMWaveFile(void)
: m_hMmio(nullptr)
, m_Offset(0)
, m_Size(0)
{
	ZeroMemory(&m_WaveFmt, sizeof(m_WaveFmt));
	m_WaveFmt.cbSize = sizeof(m_WaveFmt);
	m_WaveFmt.wFormatTag = WAVE_FORMAT_PCM;
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CMMWaveFile::~CMMWaveFile(void)
{
	Close();
}

/**********************************************************************//**
 *
 * J
 *
 ----------------------------------------------------------------------
 * @param [in]	filename	= t@C
 * @return	
*//***********************************************************************/
bool CMMWaveFile::OpenA(LPCSTR	filename)
{
	// WAVEt@CI[v
	m_hMmio = mmioOpenA( const_cast<LPSTR>(filename), nullptr, MMIO_READ );
	//G[
	if( m_hMmio == nullptr )
	{
		printf( "mmioOpenA failed.\n" );
		return false;
	}
	return _Open();
}
/// CMMWaveFile::Open Q
bool CMMWaveFile::OpenW(LPCWSTR	filename)
{
	// WAVEt@CI[v
	m_hMmio = mmioOpenW( const_cast<LPWSTR>(filename), nullptr, MMIO_READ );
	//G[
	if( m_hMmio == nullptr )
	{
		printf( "mmioOpenW failed.\n" );
		return false;
	}
	return _Open();
}

/**********************************************************************//**
 *
 * JĂ邩ǂ
 *
*//***********************************************************************/
bool CMMWaveFile::IsOpen(void) const
{
	if( m_hMmio == nullptr ) return false;
	return true;
}

/**********************************************************************//**
 *
 * t@C
 *
 ----------------------------------------------------------------------
 * @return	MMRESULTl
*//***********************************************************************/
void CMMWaveFile::Close(void)
{
	MMRESULT mmr = MMSYSERR_NOERROR;	// G[擾p

	if( m_hMmio != nullptr )
	{
		mmr = mmioClose( m_hMmio, 0 );
		WX_MM_ERROR(mmr);
		m_hMmio = nullptr;
	}
}

/**********************************************************************//**
 *
 * PCMf[^̓ǂݎ
 *
 ----------------------------------------------------------------------
 * @param [out]	lpBuffer	= o̓obt@
 * @param [in]	length		= o̓obt@
 * @return	WJobt@TCY
*//***********************************************************************/
u32 CMMWaveFile::ReadPCM(void* lpBuffer, u32 length)
{
	// f[^̓ǂݍ
	return mmioRead(m_hMmio, (HPSTR)lpBuffer, length);
}

/**********************************************************************//**
 *
 * WAVEFORMATEX̎擾
 *
 ----------------------------------------------------------------------
 * @param [out]	pwfex	= WAVEFORMATEX
 * @return	
*//***********************************************************************/
bool CMMWaveFile::GetWaveFormatEx(LPWAVEFORMATEX pwfex)	const
{
	*pwfex = m_WaveFmt;
	return true;
}

/**********************************************************************//**
 *
 * tell
 *
 ----------------------------------------------------------------------
 * @return	V[Nʒu(TvP)
*//***********************************************************************/
s32 CMMWaveFile::Tell(void)	const
{
	s32 pos = mmioSeek(m_hMmio, 0, SEEK_CUR);
	if( pos < m_Offset ) return -1;
	if( static_cast<u32>(pos) >= m_Offset + m_Size ) return -1;
	return (pos - m_Offset) / (m_WaveFmt.wBitsPerSample * m_WaveFmt.nChannels);
}

/**********************************************************************//**
 *
 * tell time
 *
 ----------------------------------------------------------------------
 * @return	V[Nʒu(bP)
*//***********************************************************************/
f64 CMMWaveFile::TellTime(void)	const
{
	s32 samples = Tell();
	if( samples == -1 ) return 0.0f;
	return (f64)samples / m_WaveFmt.nSamplesPerSec;
}

/**********************************************************************//**
 *
 * seek
 *
 ----------------------------------------------------------------------
 * @param [in]	pos	= TvP
 * @return	
*//***********************************************************************/
bool CMMWaveFile::Seek(s32 samples)
{
	s32 pos = samples * m_WaveFmt.wBitsPerSample * m_WaveFmt.nChannels;
	mmioSeek(m_hMmio, pos + m_Offset, SEEK_SET);
	return true;
}

/**********************************************************************//**
 *
 * seek time
 *
 ----------------------------------------------------------------------
 * @param [in]	time	= bP
 * @return	
*//***********************************************************************/
bool CMMWaveFile::SeekTime(f64 time)
{
	s32 samples = static_cast<s32>(time * m_WaveFmt.nSamplesPerSec);
	Seek(samples);
	return true;
}

/**********************************************************************//**
 *
 * t@Cɏ
 *
 ----------------------------------------------------------------------
 * @param [in]	filename	= t@C
 * @parma [in]	lpBuffer	= ݃obt@
 * @return	MMRESULTl
*//***********************************************************************/
template<>
MMRESULT CMMWaveFile::WriteFile<CHAR>(LPSTR filename, void* lpBuffer, s32 uSize, LPWAVEFORMATEX pwfex)
{
	// WAVEt@CI[v
	HMMIO hMmio = mmioOpenA( filename, nullptr, MMIO_CREATE | MMIO_WRITE );
	//G[
	if( hMmio == nullptr )
	{
		printf( "mmioOpenA failed.\n" );
		return MMSYSERR_ERROR;
	}
	return _Write(hMmio, lpBuffer, uSize, pwfex);
}
/// CMMWaveFile::WriteFile Q
template<>
MMRESULT CMMWaveFile::WriteFile<WCHAR>(LPWSTR filename, void* lpBuffer, s32 uSize, LPWAVEFORMATEX pwfex)
{
	// WAVEt@CI[v
	HMMIO hMmio = mmioOpenW( filename, nullptr, MMIO_CREATE | MMIO_WRITE );
	//G[
	if( hMmio == nullptr )
	{
		printf( "mmioOpenW failed.\n" );
		return MMSYSERR_ERROR;
	}
	return _Write(hMmio, lpBuffer, uSize, pwfex);
}

/**********************************************************************//**
 *
 * ʃI[v
 *
*//***********************************************************************/
bool CMMWaveFile::_Open(void)
{
	MMRESULT	mmr		= MMSYSERR_NOERROR;	// G[擾p
	MMCKINFO	riff	= {0};				// MMCKINFO\
	MMCKINFO	fmt		= {0};				// MMCKINFO\
	MMCKINFO	data	= {0};				// MMCKINFO\
	LONG read = 0;

	if( m_hMmio == nullptr ) return false;

	// ^O̕ۑ
	riff.fccType = mmioFOURCC( 'W', 'A', 'V', 'E' );

	// t@C^Cv̊mF(RIFFւ̃fBZh)
	mmr = mmioDescend( m_hMmio, &riff, nullptr, MMIO_FINDRIFF );

	// G[
	if( mmr == MMIOERR_CHUNKNOTFOUND )
		goto mmerr;

	// ^O̕ۑ
	fmt.ckid = mmioFOURCC( 'f', 'm', 't', ' ' );

	// tH[}bg`Ň(fmtւ̃fBZh)
	mmr = mmioDescend( m_hMmio, &fmt, &riff, MMIO_FINDCHUNK );

	//G[
	if( mmr == MMIOERR_CHUNKNOTFOUND )
		goto mmerr;

	// PCM̓ǂݍ
	read = mmioRead( m_hMmio, (HPSTR)&m_WaveFmt, fmt.cksize );
	if( read != fmt.cksize ) { goto exit; }

	// PCMtH[}bgWAVEȂ
	if( m_WaveFmt.wFormatTag != WAVE_FORMAT_PCM ) { goto exit; }

	// tH[}bg`NRIFF`Nֈړ
	mmr = mmioAscend( m_hMmio, &fmt, 0 );

	if( mmr != MMSYSERR_NOERROR )
		goto mmerr;

	// ^O̕ۑ
	data.ckid = mmioFOURCC( 'd', 'a', 't', 'a' );

	// f[^`Ň(dataւ̃fBZh)
	mmr = mmioDescend( m_hMmio, &data, &riff, MMIO_FINDCHUNK );

	// G[
	if( mmr == MMIOERR_CHUNKNOTFOUND )
		goto mmerr;

	m_Offset = mmioSeek(m_hMmio, 0, SEEK_CUR);

	// t@CTCY̕ۑ
	m_Size = data.cksize;

	return true;

mmerr:
	WX_MM_ERROR(mmr);
exit:
	Close();
	return false;
}

/**********************************************************************//**
 *
 * ʏݏ
 *
*//***********************************************************************/
MMRESULT CMMWaveFile::_Write(HMMIO hMmio, void* lpBuffer, s32 uSize, LPWAVEFORMATEX pwfex)
{
	MMRESULT	mmr		= MMSYSERR_NOERROR;	// G[擾p
	MMCKINFO	riff	= {0};				// MMCKINFO\
	MMCKINFO	fmt		= {0};				// MMCKINFO\
	MMCKINFO	data	= {0};				// MMCKINFO\
	LONG written = 0;

	if( hMmio == nullptr ) return MMSYSERR_ERROR;
	if( lpBuffer == nullptr ) return MMSYSERR_ERROR;

	// ^O̕ۑ
	riff.fccType = mmioFOURCC( 'W', 'A', 'V', 'E' );
	riff.cksize = 0;
	// t@C^Cv̊mF(RIFFւ̃fBZh)
	mmr = mmioCreateChunk( hMmio, &riff, MMIO_CREATERIFF );
	if( mmr != MMSYSERR_NOERROR )
		goto mmerr;

	// ^O̕ۑ
	fmt.ckid = mmioFOURCC( 'f', 'm', 't', ' ' );
	fmt.cksize = sizeof(WAVEFORMATEX);
	// tH[}bg`Ň(fmtւ̃fBZh)
	mmr = mmioCreateChunk( hMmio, &fmt, 0 );
	if( mmr != MMSYSERR_NOERROR )
		goto mmerr;

	// PCM̓ǂݍ
	LONG fmt_size = static_cast<LONG>(fmt.cksize);
	written = mmioWrite( hMmio, (LPCSTR)pwfex, fmt_size );
	if( written != fmt_size )
		goto exit;

	// tH[}bg`NRIFF`Nֈړ
	mmr = mmioAscend( hMmio, &fmt, 0 );
	if( mmr != MMSYSERR_NOERROR )
		goto mmerr;

	// ^O̕ۑ
	data.ckid = mmioFOURCC( 'd', 'a', 't', 'a' );
	data.cksize = 0;
	// f[^`Ň(dataւ̃fBZh)
	mmr = mmioCreateChunk( hMmio, &data, 0 );
	if( mmr != MMSYSERR_NOERROR )
		goto mmerr;

	// f[^̏
	written = mmioWrite( hMmio, (LPCSTR)lpBuffer, uSize );
	if( written != uSize )
		goto exit;

	// f[^`NRIFF`Nֈړ
	mmr = mmioAscend( hMmio, &data, 0 );
	if( mmr != MMSYSERR_NOERROR )
		goto mmerr;

	mmr = mmioAscend( hMmio, &riff, 0 );
	if( mmr != MMSYSERR_NOERROR )
		goto mmerr;

	// Ô߃tbV
	mmioFlush(hMmio, 0);

exit:
	mmr = mmioClose( hMmio, 0 );
	return mmr;

mmerr:
	WX_MM_ERROR(mmr);
	goto exit;
}

}	// end of namespace wx
}	// end of namespace iris


#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "../debug/unittest/WXDebugUnitTest.h"
#include "WXMMWaveOut.h"
#include "audio/format/AXAudioBuffer.h"
#include "iris_using.h"

//======================================================================
// test
IRIS_UNITTEST(CWXMMWaveFileUnitTest, Func)
{
	MMRESULT	mmr = MMSYSERR_NOERROR;//G[擾p
	CMMWaveFile	wave;
	CMMWaveOut	waveOut;
	CAXBuffer<>	buffer(&wave);

	if( !wave.Open( TEXT("../../data/snd/sample.wav") ) )
	{
		puts("wave file open failed.");
		return;
	}
	if( !buffer.Read() )
	{
		return;
	}

	// WAVEt@CI[v
	mmr = waveOut.Open(	wave.GetWaveFormatEx() );
	// G[
	if( mmr != MMSYSERR_NOERROR )
	{
		return;
	}

	// Đ
	waveOut.PrepareHeader( (LPSTR)buffer.GetAddr(), buffer.GetReadSize(), 0, 0 );
	waveOut.Write();

	WAVEFORMATEX *pWfx = wave.GetWaveFormatEx();

	{
		printf( "sample.wav̏\n" );

		printf( "FormatTag[%d]\n"		, pWfx->wFormatTag );
		printf( "Channels[%d]\n"		, pWfx->nChannels );
		printf( "SamplesPerSec[%d]\n"	, pWfx->nSamplesPerSec );
		printf( "AvgBytesPerSec[%d]\n"	, pWfx->nAvgBytesPerSec );
		printf( "BlockAlign[%d]\n"		, pWfx->nBlockAlign );
		printf( "BitsPerSample[%d]\n"	, pWfx->wBitsPerSample );
		printf( "Size[%d]\n"			, pWfx->cbSize );

		printf( "\n" );
		printf( "--------------------" );
		printf( "[ESCAPE] Close\n" );
		printf( "[Z]      Play\n" );
		printf( "[X]      Pause\n" );
		printf( "[C]      Loop Change\n" );
	}

	bool	bLoop		= true;		// [vtO
	bool	bPause		= false;	// |[YtO
	bool	bWaveLoop	= true;		// [vtO
	MMTIME	mmt			= {0};		// MMTIME\
	DWORD	dwSecond	= 0;

	mmt.wType = TIME_BYTES;

	while( bLoop )
	{
		waveOut.GetPosition(&mmt);
		// ĐԂ߂
		dwSecond = mmt.u.cb / pWfx->nAvgBytesPerSec;

		if( bWaveLoop == true )
		{
			if( mmt.u.cb >= wave.GetSizePCM() )
			{
				waveOut.Reset();
				waveOut.UnprepareHeader();
				waveOut.PrepareHeader( (LPSTR)buffer.GetAddr(), buffer.GetReadSize(), 0, 0 );
				waveOut.Write();
			}
		}
		// I
		if( GetAsyncKeyState( VK_ESCAPE ) & 0x8000 )
			bLoop = false;
		// Đ
		if( GetAsyncKeyState( 'Z' ) & 0x8000 )
		{
			waveOut.Reset();
			waveOut.UnprepareHeader();
			waveOut.PrepareHeader( (LPSTR)buffer.GetAddr(), buffer.GetReadSize(), 0, 0 );
			waveOut.Write();
			Sleep( 100 );
		}

		// |[Y
		if( GetAsyncKeyState( 'X' ) & 0x8000 )
		{
			if( bPause == false )
			{
				waveOut.Pause();
				bPause = true;
				Sleep( 100 );
			}
			else
			{
				waveOut.Restart();
				bPause = false;
				Sleep( 100 );
			}
		}

		// [v؂ւ
		if( GetAsyncKeyState( 'C' ) & 0x8000 )
		{
			if( bWaveLoop == false )
			{
				bWaveLoop = true;
				Sleep( 100 );
			}
			else
			{
				bWaveLoop = false;
				Sleep( 100 );
			}
		}
	}

	// WAVEt@C
	waveOut.Reset();
	waveOut.UnprepareHeader();
	waveOut.Close();
	wave.Close();
}

#endif	// #if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))

#endif
