//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXMMTimePeriod.cpp
 * @brief		WXMMTimePeriod t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXMMTimePeriod_CPP_

//======================================================================
// include
#include "WXMMTimePeriod.h"
#include "WXMMSysError.h"
#include <mmsystem.h>

//======================================================================
// link
#if defined(IRIS_MSC)
#  if	defined(IRIS_WIN32_WCE)
#    pragma comment( lib, "mmtimer.lib")
#  else
#    pragma comment( lib, "winmm.lib" )
#  endif
#endif

namespace iris {
namespace wx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CMMTimePeriod::CMMTimePeriod(void)
: m_Period(0)
{
}

/**********************************************************************//**
 *
 * RXgN^
 *
 -----------------------------------------------------------------------
 * @param [in]	uPeriod	= \
*//***********************************************************************/
CMMTimePeriod::CMMTimePeriod(UINT uPeriod)
: m_Period(0)
{
	Begin(uPeriod);
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CMMTimePeriod::~CMMTimePeriod(void)
{
	End();
}

/**********************************************************************//**
 *
 * ݒJn
 *
 -----------------------------------------------------------------------
 * @param [in]	uPeriod	= \
 * @return	
*//***********************************************************************/
bool CMMTimePeriod::Begin(UINT uPeriod)
{
	End();
	MMRESULT mmResult = timeBeginPeriod(uPeriod);
	WX_MM_DO_CHECK_RESULT(mmResult, return false);
	m_Period = uPeriod;
	return true;
}

/**********************************************************************//**
 *
 * ݒI
 *
*//***********************************************************************/
void CMMTimePeriod::End(void)
{
	if( m_Period != 0 )
		WX_MM_VERIFY( timeEndPeriod(m_Period) );
}

}	// end of namespace wx
}	// end of namespace iris
