//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXMMMP3File.h
 * @brief		MP3t@CNX
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXMMMP3File_H_
#define INCG_IRIS_WXMMMP3File_H_

//======================================================================
// include
#include "audio/format/AXAudioFile.h"
#include "../io/WXHFile.h"
#include <mmreg.h>
#include <msacm.h>

namespace iris {
namespace wx
{

//======================================================================
// struct
//! MP3f[^̃t[wb_
typedef struct tagMP3FRAMEHEADER
{
	union
	{
		struct
		{
			BYTE	Header1:8;	//!< wb_(8rbgSĂ1)
		};
		BYTE	m1;
	};

	union
	{
		struct
		{
			BYTE	Header2:3;			//!< wb_(3rbgSĂ1)
			BYTE	Version:2;			//!< o[W(0x00:MPEG2.5, 0x01:\, 0x10:MPEG2, 0x11:MPEG1)
			BYTE	Layer:2;			//!< C[(0x00:\, 0x01:Layer3, 0x10:Layer2, 0x11:Layer1)
			BYTE	ErrorProtection:1;	//!< G[ی(0x00:Ȃ, 0x01:)
		};
		BYTE	m2;
	};

	union
	{
		struct
		{
			BYTE	BitRate:4;		//!< rbg[g
			BYTE	SampleRate:2;	//!< TvO[g
			BYTE	Padding:1;		//!< pfBO
			BYTE	Expansion:1;	//!< g(0x00:, 0x01:vCx[g)
		};
		BYTE	m3;
	};

	union
	{
		struct
		{
			BYTE	Channels:2;			//!< `l[h(0x00:XeI, 0x01:WCgXeI, 0x10:fA`l, 0x11:m)
			BYTE	ExpansionMode:2;	//!< g[h
			BYTE	Copyright:1;		//!< 쌠(0x00:Ȃ, 0x01:)
			BYTE	Original:1;			//!< IWi(0x00:Rs[, 0x01:IWi)
			BYTE	Emphasis:2;			//!< Gt@VX(0x00:Ȃ, 0x01:50/15ms, 0x10:\, 0x11:CCITTj.17 )
		};
		BYTE	m4;
	};
} MP3FRAMEHEADER
, *LPMP3FRAMEHEADER;	//!< MP3FRAMEHEADER*

//======================================================================
// class
/**
 * @brief	MP3t@CNX
 * @note	GetStreamSize֐mȒlȂ߁AXg[ĐΉł܂B
*/
class CMMMP3File : public ax::IAXFile
{
	enum { WORK_SIZE = 2048 };
protected:
	CHFile					m_File;						//!< t@C
	HACMSTREAM				m_hAcmstream;				//!< ϊXg[̃nh
	WAVEFORMATEX			m_WaveFmt;					//!< tH[}bg
	MPEGLAYER3WAVEFORMAT	m_Mp3Fmt;					//!< MP3tH[}bg
	s32						m_Offset;					//!< f[^ւ̃ItZbg
	u32						m_FrameSize;				//!< t[f[^TCY
	u32						m_Size;						//!< TCY
	u8						m_DecodeBuffer[WORK_SIZE];	//!< fR[h[NTCY
	u32						m_DecodeRestSize;			//!< cTCY

public:
	// RXgN^
	CMMMP3File(void);
	// fXgN^
	virtual ~CMMMP3File(void);
public:
	// obt@f[^̉
	virtual void			Release(void);

public:
	// J
	virtual	bool			OpenA(LPCSTR   filename);
	virtual	bool			OpenW(LPCWSTR  filename);
	virtual bool			IsOpen(void)	const;
	// t@C
	virtual void			Close(void);

	// fR[h
	virtual	s32				Decode(void* lpBuffer, u32 dstSize, u32 srcSize);
	// PCMf[^̓ǂݎ
	virtual u32				ReadPCM(void* lpBuffer, u32 length);
	// WAVEFORMATEX̎擾
	virtual bool			GetWaveFormatEx(LPWAVEFORMATEX pwfex)	const;
	// WAVEFORMATEX̎擾
	virtual LPWAVEFORMATEX	GetWaveFormatEx(void)			{ return &m_WaveFmt; }
	// f[^TCY̎擾
	virtual	u32				GetSize(void)		const		{ return m_FrameSize; }
	// f[^TCY̎擾
	virtual	u32				GetSizePCM(void)	const		{ return m_Size; }

public:
	// tell
	virtual s32		Tell(void)	const;
	// tell time
	virtual f64		TellTime(void)	const;
	// seek
	virtual	bool	Seek(s32 samples);
	// seek (time)
	virtual	bool	SeekTime(f64 time);

protected:
	// ʃI[v
	virtual	bool			_Open(void);

protected:
	// Xg[̏
	virtual MMRESULT		InitStream(void);

public:
	// WJ̃tH[}bg擾
	virtual MMRESULT		ReadWaveFormatEx(LPWAVEFORMATEX pWfx);

	// WJ̃TCY̎擾
	virtual DWORD			GetStreamSize(DWORD dwBufferSize, DWORD fdwSize)	const;
};

}	// end of namespace wx
}	// end of namespace iris

#endif
