//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXMMAviWav.h
 * @brief		AviWav t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXMMAviWav_H_70D0B474_9B8E_4020_9D78_11418089ED02
#define INCG_IRIS_WXMMAviWav_H_70D0B474_9B8E_4020_9D78_11418089ED02

//======================================================================
// include
#include "WXMMAviStream.h"
#include "audio/format/AXAudioFile.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/**
 * @brief	AVI Wave NX
*/
class CMMAviWav : public CMMAviStream, public ax::IAXFile
{
protected:
	WAVEFORMATEX	m_WaveFmt;	//!< tH[}bg
	s32				m_Start;	//!< Jnʒu
	s32				m_Offset;	//!< ItZbg
	u32				m_Size;		//!< TCY

public:
	// RXgN^
	CMMAviWav(void);
	// fXgN^
	virtual ~CMMAviWav(void);

public:
	template<typename CHARTYPE_>
	bool			Open(const CHARTYPE_* fname
		, typename enable_if_t< cpp0x::is_same<CHARTYPE_, CHAR> >::type*& =cpp0x::enabler::value)	{ return OpenA(fname); }
	template<typename CHARTYPE_>
	bool			Open(const CHARTYPE_* fname
		, typename enable_if_t< cpp0x::is_same<CHARTYPE_, WCHAR> >::type*& =cpp0x::enabler::value)	{ return OpenW(fname); }

	template<typename CHARTYPE_>
	bool			Open(const CHARTYPE_* filename, DWORD fccType, LONG lParam, UINT uMode, LPCLSID lpHandler=nullptr)
	{
		if( !CMMAviStream::Open(filename, fccType, lParam, uMode, lpHandler) ) return false;
		return Init();
	}
	// J
	virtual	bool			OpenA(LPCSTR   filename);
	virtual	bool			OpenW(LPCWSTR  filename);
	virtual bool			IsOpen(void)	const;
	// 
	virtual	void			Close(void);

public:
	// 
	bool	Init(void);

public:
	// PCMf[^̓ǂݎ
	virtual u32				ReadPCM(void* lpBuffer, u32 length);
	// WAVEFORMATEX̎擾
	virtual bool			GetWaveFormatEx(LPWAVEFORMATEX pwfex)	const;
	// WAVEFORMATEX̎擾
	virtual LPWAVEFORMATEX	GetWaveFormatEx(void)			{ return &m_WaveFmt; }
	// f[^TCY̎擾
	virtual	u32				GetSize(void)		const		{ return m_Size; }
	// f[^TCY̎擾
	virtual	u32				GetSizePCM(void)	const;

public:
	// tell
	virtual s32		Tell(void)	const;
	// tell time
	virtual f64		TellTime(void)	const;
	// seek
	virtual	bool	Seek(s32 samples);
	// seek (time)
	virtual	bool	SeekTime(f64 time);

};

}	// end of namespace wx
}	// end of namespace iris


#endif
