//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXMMAviFile.h
 * @brief		AviFile t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXMMAviFile_H_
#define INCG_IRIS_WXMMAviFile_H_

//======================================================================
// include
#include "WXMMVfw.h"

namespace iris {
namespace wx
{

//======================================================================
// declare
class CMMAviStream;

//======================================================================
// class
/**
 * @brief	AVI t@CNX
*/
class CMMAviFile : private INonCopyable<CMMAviFile>
{
	CMMVfw	m_Vfw;	//!< vfw IuWFNg

protected:
	PAVIFILE	m_pFile;	//!< t@C|C^

public:
	// RXgN^
	CMMAviFile(void);
	CMMAviFile(const CMMAviFile& rhs);
	// fXgN^
	~CMMAviFile(void);

public:
	// J
	template<typename CHARTYPE_>
	bool			Open(const CHARTYPE_* filename, UINT uMode, LPCLSID lpHandler=nullptr);
	bool			IsOpen(void)	const;
	// 
	void			Close(void);

public:
	// N[
	void			Clone(const CMMAviFile& rhs);

public:
	// ̎擾
	template<typename FILEINFO_>
	bool			GetInfo(FILEINFO_* lpInfo, s32 lSize) const;

public:
	// Xg[̑擾
	DWORD			GetStreamCount(void) const;
	// Xg[I[v
	bool			GetStream(CMMAviStream* stream, DWORD fccType, LONG lParam);
	bool			GetStream(PAVISTREAM* stream, DWORD fccType, LONG lParam);

public:
	PAVIFILE		GetFile(void) const { return m_pFile; }
	operator PAVIFILE (void) const		{ return m_pFile; }
};

}	// end of namespace wx
}	// end of namespace iris


#endif
