//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXMMAviFile.cpp
 * @brief		AviFile t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXMMAviFile_CPP_

//======================================================================
// include
#include "WXMMAviFile.h"
#include "WXMMAviStream.h"
#include "../os/modules/WXMAvifil.h"

namespace iris {
namespace wx
{


/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CMMAviFile::CMMAviFile(void)
: m_pFile(nullptr)
{
}

/**********************************************************************//**
 *
 * Rs[RXgN^
 *
*//***********************************************************************/
CMMAviFile::CMMAviFile(const CMMAviFile& rhs)
: m_pFile(nullptr)
{
	Clone(rhs);
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CMMAviFile::~CMMAviFile(void)
{
	Close();
}

/**********************************************************************//**
 *
 * J
 *
 ----------------------------------------------------------------------
 * @param [in]	filename	= t@C
 * @param [in]	uMode		= t@CI[v[h
 * @param [in]	lpHandler	=
 * @return	
*//***********************************************************************/
template<>
bool CMMAviFile::Open<CHAR>(LPCSTR	filename, UINT uMode, LPCLSID lpHandler)
{
	if( FAILED( CAvifil::AVIFileOpenA(&m_pFile, filename, uMode, lpHandler) ) ) return false;
	return IsOpen();
}
template<>
bool CMMAviFile::Open<WCHAR>(LPCWSTR	filename, UINT uMode, LPCLSID lpHandler)
{
	if( FAILED( CAvifil::AVIFileOpenW(&m_pFile, filename, uMode, lpHandler) ) ) return false;
	return IsOpen();
}

/**********************************************************************//**
 *
 * JĂ邩ǂ
 *
 ----------------------------------------------------------------------
 * @return	^Ul
*//***********************************************************************/
bool CMMAviFile::IsOpen(void) const
{
	if( m_pFile == nullptr ) return false;
	return true;
}

/**********************************************************************//**
 *
 * t@C
 *
*//***********************************************************************/
void CMMAviFile::Close(void)
{
	if( m_pFile != nullptr )
	{
		CAvifil::AVIFileRelease(m_pFile);
		m_pFile = nullptr;
	}
}

/**********************************************************************//**
 *
 * N[
 *
 ----------------------------------------------------------------------
 * @param [in]	rhs		= Rs[
*//***********************************************************************/
void CMMAviFile::Clone(const CMMAviFile& rhs)
{
	Close();
	if( rhs.m_pFile == nullptr ) return;
	m_pFile = rhs.m_pFile;
	CAvifil::AVIFileAddRef(m_pFile);
}

/**********************************************************************//**
 *
 * ̎擾
 *
 ----------------------------------------------------------------------
 * @param [out]	lpInfo		= o
 * @param [in]	lSize		= o̓obt@TCY
 * @return 
*//***********************************************************************/
template<>
bool CMMAviFile::GetInfo(LPAVIFILEINFOA lpInfo, s32 lSize) const
{
	if( lpInfo == nullptr ) return false;
	if( FAILED( CAvifil::AVIFileInfoA(m_pFile, lpInfo, lSize) ) ) return false;
	return true;
}
template<>
bool CMMAviFile::GetInfo(LPAVIFILEINFOW lpInfo, s32 lSize) const
{
	if( lpInfo == nullptr ) return false;
	if( FAILED( CAvifil::AVIFileInfoW(m_pFile, lpInfo, lSize) ) ) return false;
	return true;
}

/**********************************************************************//**
 *
 * Xg[̑擾
 *
 ----------------------------------------------------------------------
 * @return	Xg[̑
*//***********************************************************************/
DWORD CMMAviFile::GetStreamCount(void) const
{
	AVIFILEINFO fi;
	if( !GetInfo(&fi, sizeof(fi)) ) return 0;
	return fi.dwStreams;
}

/**********************************************************************//**
 *
 * Xg[J
 *
 ----------------------------------------------------------------------
 * @param [out]	stream	= Xg[NX
 * @param [in]	fccType	= Xg[^Cv
 * @param [in]	lParam	= [U[f[^
 * @return	
*//***********************************************************************/
bool CMMAviFile::GetStream(CMMAviStream* stream, DWORD fccType, LONG lParam)
{
	return GetStream(&stream->m_pStream, fccType, lParam);
}
bool CMMAviFile::GetStream(PAVISTREAM* stream, DWORD fccType, LONG lParam)
{
	if( FAILED( CAvifil::AVIFileGetStream(m_pFile, stream, fccType, lParam) ) ) return false;
	return true;
}


}	// end of namespace wx
}	// end of namespace iris

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "../debug/unittest/WXDebugUnitTest.h"
#include "iris_tchar.h"
#include "iris_using.h"

//======================================================================
// test
IRIS_UNITTEST(CWXMMAviFileTest, Info)
{
	CMMAviFile avi;

	TCHAR path[MAX_PATH];
#ifndef _IRIS_SUPPORT_AUTO_UNITTEST
	std::cout << "Jt@C͂ĂB" << std::endl;
	std::tcin >> path;
#endif

	if( !avi.Open(path, OF_READ) )
	{
		_tprintf(path);
		_tprintf(IRIS_TEXT("\n"));
		std::cout << "t@CI[vɎs܂B" << std::endl;
		return;
	}

	AVIFILEINFO fi;
	if( !avi.GetInfo(&fi, sizeof(fi)) ) return;

    _tprintf(IRIS_TEXT("szFileType            = %s\n")    , fi.szFileType );
    _tprintf(IRIS_TEXT("dwCaps                = 0x%x\n")  , fi.dwCaps );
    _tprintf(IRIS_TEXT("dwEditCount           = %d\n")    , fi.dwEditCount );
    _tprintf(IRIS_TEXT("dwFlags               = 0x%x\n")  , fi.dwFlags );
    _tprintf(IRIS_TEXT("dwWidth               = %d\n")    , fi.dwWidth );
    _tprintf(IRIS_TEXT("dwHeight              = %d\n")    , fi.dwHeight );
    _tprintf(IRIS_TEXT("dwLength              = 0x%x\n")  , fi.dwLength );
    _tprintf(IRIS_TEXT("dwMaxBytesPerSec      = 0x%x\n")  , fi.dwMaxBytesPerSec );
    _tprintf(IRIS_TEXT("dwRate                = 0x%x\n")  , fi.dwRate );
    _tprintf(IRIS_TEXT("dwScale               = 0x%x\n")  , fi.dwScale );
    _tprintf(IRIS_TEXT("dwStreams             = %d\n")    , fi.dwStreams );
    _tprintf(IRIS_TEXT("dwSuggestedBufferSize = 0x%x\n"), fi.dwSuggestedBufferSize );

}

#endif
