//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXLocalMemory.cpp
 * @brief		[JnhNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXLocalMemory_CPP_

//======================================================================
// include
#include "WXLocalMemory.h"

namespace iris {
namespace wx
{

//======================================================================
// class

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CLocalMemory::CLocalMemory(void)
: m_hMem(nullptr)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CLocalMemory::~CLocalMemory(void)
{
	Free();
}

/**********************************************************************//**
 *
 * Attach
 *
 * @note	Ȃ̂Œ
 *
 ----------------------------------------------------------------------
 * @param [in]	hMem	= 蓖Ănh
 * @return	ȑÕnh
*//***********************************************************************/
HGLOBAL CLocalMemory::Attach(HGLOBAL hMem)
{
	HLOCAL hPreMem = m_hMem;
	m_hMem = hMem;
	return hPreMem;
}

/**********************************************************************//**
 *
 * Attach
 *
 * @note	Ȃ̂Œ
 *
 ----------------------------------------------------------------------
 * @return	ȑÕnh
*//***********************************************************************/
HGLOBAL CLocalMemory::Detach(void)
{
	HLOCAL hPreMem = m_hMem;
	m_hMem = nullptr;
	return hPreMem;
}

/**********************************************************************//**
 *
 * Alloc
 *
 ----------------------------------------------------------------------
 * @param [in]	uFlags	= LMEM_***
 * @param [in]	dwBytes	= 蓖ĂoCg
 * @return	
*//***********************************************************************/
bool CLocalMemory::Alloc(UINT uFlags, SIZE_T dwBytes)
{
	m_hMem = LocalAlloc(uFlags, dwBytes);
	return (m_hMem != 0);
}

/**********************************************************************//**
 *
 * ReAlloc
 *
 ----------------------------------------------------------------------
 * @param [in]	uFlags	= GMEM_***
 * @param [in]	dwBytes	= 蓖ĂoCg
 * @return	
*//***********************************************************************/
bool CLocalMemory::ReAlloc(UINT uFlags, SIZE_T dwBytes)
{
	if( m_hMem == nullptr ) return false;
	m_hMem = LocalReAlloc(m_hMem, dwBytes, uFlags);
	return (m_hMem != 0);
}

/**********************************************************************//**
 *
 * 폜ibNJEg0̂ƂA폜j
 *
*//***********************************************************************/
void CLocalMemory::Discard(void)
{
	if( m_hMem != nullptr )
		m_hMem = LocalDiscard(m_hMem);
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
void CLocalMemory::Free(void)
{
	if( m_hMem != nullptr )
		LocalFree(m_hMem);
	m_hMem = nullptr;
}

/**********************************************************************//**
 *
 * Lock
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
LPVOID CLocalMemory::Lock(void)
{
	if( m_hMem == nullptr ) return nullptr;
	return LocalLock(m_hMem);
}

/**********************************************************************//**
 *
 * Unlock
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CLocalMemory::Unlock(void)
{
	return LocalUnlock(m_hMem);
}

/**********************************************************************//**
 *
 * TCY擾
 *
 ----------------------------------------------------------------------
 * @return	TCY
*//***********************************************************************/
SIZE_T CLocalMemory::GetSize(void)	const
{
	if( m_hMem == nullptr ) return 0;
	return LocalSize(m_hMem);
}

/**********************************************************************//**
 *
 * tO擾
 *
 ----------------------------------------------------------------------
 * @return	tO
*//***********************************************************************/
UINT CLocalMemory::GetFlags(void)	const
{
	if( m_hMem == nullptr ) return 0;
	return LocalFlags(m_hMem);
}

}	// end of namespace wx
}	// end of namespace iris
