//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXPipe.cpp
 * @brief		pCvt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXPipe_CPP_

//======================================================================
// include
#include "WXPipe.h"
#include "../os/modules/WXMKernel.h"

namespace iris {
namespace wx
{

//======================================================================
// class
// CNamedPipe
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CNamedPipe::CNamedPipe(void)
{
}

/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	hFile		= ֘Atnh
*//***********************************************************************/
CNamedPipe::CNamedPipe(HANDLE hFile)
: CHFile(hFile)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CNamedPipe::~CNamedPipe(void)
{
}

/**********************************************************************//**
 *
 * 쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	lpPipeName				= pCv
 * @param [in]	dwOpenMode				= pCvANZXAI[o[bvi񓯊jACgX[AZLeB̊e[hݒ
 *											( PIPE_ACCESS_*** ) ( FILE_FLAG_WRITE_THROUGH or FILE_FLAG_OVERLAPPED ) (WRITE_*** or ACCESS_SYSTEM_SECURITY)
 * @param [in]	dwPipeMode				= pCvnh̃^CvAǂݎ胂[hAҋ@[h
 *											( PIPE_TYPE_*** ) ( PIPE_READMODE_*** ) ( PIPE_WAIT or PIPE_NOWAIT )
 * @param [in]	nMaxInstance			= CX^X̍ő吔
 * @param [in]	nOutBufferSize			= o̓obt@̃TCY
 * @param [in]	nInBufferSize			= ̓obt@̃TCY
 * @param [in]	nTimeout				= ^CAEg̊Ԋu
 * @param [in]	lpSecurityAttributes	= ZLeBLqq
 * @return	
*//***********************************************************************/
BOOL CNamedPipe::Create (LPCTSTR lpPipeName, DWORD dwOpenMode, DWORD dwPipeMode, DWORD nMaxInstance
					, DWORD nOutBufferSize, DWORD nInBufferSize, DWORD nTimeout, LPSECURITY_ATTRIBUTES lpSecurityAttributes)
{
#ifdef UNICODE
	return CreateW(lpPipeName, dwOpenMode, dwPipeMode, nMaxInstance
		, nOutBufferSize, nInBufferSize, nTimeout, lpSecurityAttributes);
#else
	return CreateA(lpPipeName, dwOpenMode, dwPipeMode, nMaxInstance
		, nOutBufferSize, nInBufferSize, nTimeout, lpSecurityAttributes);
#endif
}
/// CNamedPipe::Create Q
BOOL CNamedPipe::CreateA(LPCSTR  lpPipeName, DWORD dwOpenMode, DWORD dwPipeMode, DWORD nMaxInstance
					, DWORD nOutBufferSize, DWORD nInBufferSize, DWORD nTimeout, LPSECURITY_ATTRIBUTES lpSecurityAttributes)
{
	HANDLE hObject = CreateNamedPipeA(lpPipeName, dwOpenMode, dwPipeMode, nMaxInstance
								, nOutBufferSize, nInBufferSize, nTimeout, lpSecurityAttributes);
	if( hObject == INVALID_HANDLE_VALUE ) return FALSE;
	return TryAttach(hObject);
}
/// CNamedPipe::Create Q
BOOL CNamedPipe::CreateW(LPCWSTR lpPipeName, DWORD dwOpenMode, DWORD dwPipeMode, DWORD nMaxInstance
					, DWORD nOutBufferSize, DWORD nInBufferSize, DWORD nTimeout, LPSECURITY_ATTRIBUTES lpSecurityAttributes)
{
	HANDLE hObject = CreateNamedPipeW(lpPipeName, dwOpenMode, dwPipeMode, nMaxInstance
								, nOutBufferSize, nInBufferSize, nTimeout, lpSecurityAttributes);
	if( hObject == INVALID_HANDLE_VALUE ) return FALSE;
	return TryAttach(hObject);
}

/**********************************************************************//**
 *
 * ڑ
 *
 ----------------------------------------------------------------------
 * @param [in]	lpOverlapped = OVERLAPPED
 * @return	
*//***********************************************************************/
BOOL CNamedPipe::Connect(LPOVERLAPPED lpOverlapped)
{
	return ConnectNamedPipe(m_hObject, lpOverlapped);
}

/**********************************************************************//**
 *
 * ؒf
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CNamedPipe::Disconnect(void)
{
	return DisconnectNamedPipe(m_hObject);
}

/**********************************************************************//**
 *
 * pCṽf[^Rs[я̎擾
 *
 ----------------------------------------------------------------------
 * @param [out]	lpBuffer				= f[^̏o̓obt@
 * @param [in]	dwBufferSize			= lpBuffer̃TCY
 * @param [out]	lpBytesRead				= ǂݎoCg
 * @param [out]	lpTotalBytesAvail		= ǂݎ\ȍvoCg
 * @param [out]	lpBytesLeftThisMessage	= ܂ǂݎĂȂoCg
 * @return	
*//***********************************************************************/
BOOL CNamedPipe::Peek(LPVOID lpBuffer, DWORD dwBufferSize, LPDWORD lpBytesRead, LPDWORD lpTotalBytesAvail, LPDWORD lpBytesLeftThisMessage)
{
	return PeekNamedPipe(m_hObject, lpBuffer, dwBufferSize, lpBytesRead, lpTotalBytesAvail, lpBytesLeftThisMessage);
}

/**********************************************************************//**
 *
 * pCṽf[^Rs[я̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	lpInBuffer		= ݃obt@
 * @param [in]	dwInBufferSize	= lpInBuffer̃TCY
 * @param [out]	lpOutBuffer		= ǂݍ݃obt@
 * @param [in]	dwOutBufferSize	= lpOutBuffer̃TCY
 * @param [out]	lpBytesRead		= ǂݎoCg
 * @param [in]	lpOverlapped	= OVERLAPPED
 * @return	
*//***********************************************************************/
BOOL CNamedPipe::Transact(LPVOID lpInBuffer, DWORD dwInBufferSize, LPVOID lpOutBuffer, DWORD dwOutBufferSize, LPDWORD lpBytesRead, LPOVERLAPPED lpOverlapped)
{
	return ::TransactNamedPipe(m_hObject, lpInBuffer, dwInBufferSize, lpOutBuffer, dwOutBufferSize, lpBytesRead, lpOverlapped);
}

/**********************************************************************//**
 *
 * Ԃ̎擾
 *
 ----------------------------------------------------------------------
 * @param [out]	lpState					= ݂̏
 * @param [out]	lpCurInstances			= ݂̃CX^X
 * @param [out]	lpMaxCollectionCount	= CX^X̍ő吔
 * @param [out]	lpCollectDataTimeout	= ^CAEg̊Ԋu
 * @param [out]	lpUserName				= [U[
 * @param [in]	nMaxUserNameSize		= lpUserNamẽTCY
 * @return	
*//***********************************************************************/
BOOL CNamedPipe::GetState (LPDWORD lpState, LPDWORD lpCurInstances, LPDWORD lpMaxCollectionCount, LPDWORD lpCollectDataTimeout
				, LPTSTR lpUserName, DWORD nMaxUserNameSize) const
{
	return ::GetNamedPipeHandleState(m_hObject, lpState, lpCurInstances, lpMaxCollectionCount, lpCollectDataTimeout
				, lpUserName, nMaxUserNameSize);
}
/// CNamedPipe::GetState Q
BOOL CNamedPipe::GetStateA(LPDWORD lpState, LPDWORD lpCurInstances, LPDWORD lpMaxCollectionCount, LPDWORD lpCollectDataTimeout
				, LPSTR  lpUserName, DWORD nMaxUserNameSize) const
{
	return ::GetNamedPipeHandleStateA(m_hObject, lpState, lpCurInstances, lpMaxCollectionCount, lpCollectDataTimeout
				, lpUserName, nMaxUserNameSize);
}
/// CNamedPipe::GetState Q
BOOL CNamedPipe::GetStateW(LPDWORD lpState, LPDWORD lpCurInstances, LPDWORD lpMaxCollectionCount, LPDWORD lpCollectDataTimeout
				, LPWSTR lpUserName, DWORD nMaxUserNameSize) const
{
	return ::GetNamedPipeHandleStateW(m_hObject, lpState, lpCurInstances, lpMaxCollectionCount, lpCollectDataTimeout
				, lpUserName, nMaxUserNameSize);
}

/**********************************************************************//**
 *
 * Ԃ̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	lpMode					= V[h(PIPE_READMODE_***) (PIPE_WAIT or PIPE_NOWAIT)
 * @param [out]	lpMaxCollectionCount	= ő~σoCg
 * @param [out]	lpCollectDataTimeout	= ^CAEg̒l
 * @return	
*//***********************************************************************/
BOOL CNamedPipe::SetState(LPDWORD lpMode, LPDWORD lpMaxCollectionCount, LPDWORD lpCollectDataTimeout)
{
	return SetNamedPipeHandleState(m_hObject, lpMode, lpMaxCollectionCount, lpCollectDataTimeout);
}

/**********************************************************************//**
 *
 * ̎擾
 *
 ----------------------------------------------------------------------
 * @param [out]	lpFlags				= pCṽ^Cv
 * @param [out]	lpOutBufferSize		= o̓obt@̃TCY
 * @param [out]	lpInBufferSize		= ̓obt@̃TCY
 * @param [out]	lpMaxInstances		= CX^X̍ő吔
 * @return	
*//***********************************************************************/
BOOL CNamedPipe::GetInfo(LPDWORD lpFlags, LPDWORD lpOutBufferSize, LPDWORD lpInBufferSize, LPDWORD lpMaxInstances)	const
{
	return ::GetNamedPipeInfo(m_hObject, lpFlags, lpOutBufferSize, lpInBufferSize, lpMaxInstances);
}

/**********************************************************************//**
 *
 * ZLeB̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	AttributeType			= ^Cv
 * @param [in]	lpAttributeName			= 
 * @param [out]	lpAttributeValue		= l
 * @param [io]	lpAttributeValueLength	= lobt@̃TCY
 * @return	
*//***********************************************************************/
BOOL CNamedPipe::GetAttribute(PIPE_ATTRIBUTE_TYPE AttributeType, LPSTR lpAttributeName
							  , LPVOID lpAttributeValue, PSIZE_T lpAttributeValueLength) const
{
#if	(_WIN32_WINNT>=0x0600) && 0
	return ::GetNamedPipeAttribute(m_hObject, AttributeType, lpAttributeName, lpAttributeValue, lpAttributeValueLength);
#else
	return CKernel::GetNamedPipeAttribute(m_hObject, AttributeType, lpAttributeName, lpAttributeValue, lpAttributeValueLength);
#endif
}

/**********************************************************************//**
 *
 * ZLeB̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	AttributeType			= ^Cv
 * @param [in]	lpAttributeName			= 
 * @param [out]	lpAttributeValue		= l
 * @param [io]	lpAttributeValueLength	= lobt@̃TCY
 * @return	
*//***********************************************************************/
BOOL CNamedPipe::SetAttribute(PIPE_ATTRIBUTE_TYPE AttributeType, LPSTR lpAttributeName, LPVOID lpAttributeValue, SIZE_T AttributeValueLength)
{
#if	(_WIN32_WINNT>=0x0600) && 0
	return ::SetNamedPipeAttribute(m_hObject, AttributeType, lpAttributeName, lpAttributeValue, AttributeValueLength);
#else
	return CKernel::SetNamedPipeAttribute(m_hObject, AttributeType, lpAttributeName, lpAttributeValue, AttributeValueLength);
#endif
}

/**********************************************************************//**
 *
 * NCAgPC擾
 *
 ----------------------------------------------------------------------
 * @param [out]	lpName		= o̓obt@
 * @param [in]	dwLength	= obt@
 * @return	
*//***********************************************************************/
BOOL CNamedPipe::GetClientComputerName (LPTSTR lpName, DWORD dwLength) const
{
#ifdef UNICODE
	return GetClientComputerNameW(lpName, dwLength);
#else
	return GetClientComputerNameA(lpName, dwLength);
#endif
}
/** @ref GetClientComputerName */
BOOL CNamedPipe::GetClientComputerNameA(LPSTR  lpName, DWORD dwLength) const
{
#if	(_WIN32_WINNT>=0x0600) && 0
	return ::GetNamedPipeClientComputerNameA(m_hObject, lpName, dwLength);
#else
	return CKernel::GetNamedPipeClientComputerNameA(m_hObject, lpName, dwLength);
#endif
}
/** @ref GetClientComputerName */
BOOL CNamedPipe::GetClientComputerNameW(LPWSTR lpName, DWORD dwLength) const
{
#if	(_WIN32_WINNT>=0x0600) && 0
	return ::GetNamedPipeClientComputerNameW(m_hObject, lpName, dwLength);
#else
	return CKernel::GetNamedPipeClientComputerNameW(m_hObject, lpName, dwLength);
#endif
}

/**********************************************************************//**
 *
 * NCAg̃vZXID擾
 *
 ----------------------------------------------------------------------
 * @param [out]	lpProcessID	= vZXID̊i[AhX
 * @return	
*//***********************************************************************/
BOOL CNamedPipe::GetClientProcessID(PULONG lpProcessID) const
{
#if	(_WIN32_WINNT>=0x0600) && 0
	return ::GetNamedPipeClientProcessId(m_hObject, lpProcessID);
#else
	return CKernel::GetNamedPipeClientProcessId(m_hObject, lpProcessID);
#endif
}

/**********************************************************************//**
 *
 * NCAg̃ZbVID擾
 *
 ----------------------------------------------------------------------
 * @param [out]	lpSessionID	= ZbVID̊i[AhX
 * @return	
*//***********************************************************************/
BOOL CNamedPipe::GetClientSessionID(PULONG lpSessionID) const
{
#if	(_WIN32_WINNT>=0x0600) && 0
	return ::GetNamedPipeServerSessionId(m_hObject, lpSessionID);
#else
	return CKernel::GetNamedPipeClientSessionId(m_hObject, lpSessionID);
#endif
}

/**********************************************************************//**
 *
 * T[o[̃vZXID擾
 *
 ----------------------------------------------------------------------
 * @param [out]	lpProcessID	= vZXID̊i[AhX
 * @return	
*//***********************************************************************/
BOOL CNamedPipe::GetServerProcessID(PULONG lpProcessID) const
{
#if	(_WIN32_WINNT>=0x0600) && 0
	return ::GetNamedPipeServerProcessId(m_hObject, lpProcessID);
#else
	return CKernel::GetNamedPipeServerProcessId(m_hObject, lpProcessID);
#endif
}

/**********************************************************************//**
 *
 * T[o[̃ZbVID擾
 *
 ----------------------------------------------------------------------
 * @param [out]	lpSessionID	= ZbVID̊i[AhX
 * @return	
*//***********************************************************************/
BOOL CNamedPipe::GetServerSessionID(PULONG lpSessionID) const
{
#if	(_WIN32_WINNT>=0x0600) && 0
	return ::GetNamedPipeServerSessionId(m_hObject, lpSessionID);
#else
	return CKernel::GetNamedPipeServerSessionId(m_hObject, lpSessionID);
#endif
}

// CPipe
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CPipe::CPipe(void)
{
}

/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	hRead	= ǂݎppCvnh
 * @param [in]	hWrite	= ݗppCvnh
*//***********************************************************************/
CPipe::CPipe(HANDLE hRead, HANDLE hWrite)
: m_ReadPipe(hRead)
, m_WritePipe(hWrite)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CPipe::~CPipe(void)
{
	Close();
}

/**********************************************************************//**
 *
 * ֘At
 *
 ----------------------------------------------------------------------
 * @param [in]	hRead	= ǂݎppCvnh
 * @param [in]	hWrite	= ݗppCvnh
 * @return 
*//***********************************************************************/
BOOL CPipe::Attach(HANDLE hRead, HANDLE hWrite)
{
	if( !m_ReadPipe.Attach(hRead) ) return FALSE;
	if( !m_WritePipe.Attach(hWrite) ) return FALSE;
	return TRUE;
}

/**********************************************************************//**
 *
 * ֘At
 *
 ----------------------------------------------------------------------
 * @param [in]	hRead	= ֘AtĂǂݎppCvnh
 * @param [in]	hWrite	= ֘AtĂݗppCvnh
 * @return 
*//***********************************************************************/
BOOL CPipe::Detach(PHANDLE hRead, PHANDLE hWrite)
{
	HANDLE hObj = m_ReadPipe.Detach();
	if( hRead != nullptr ) *hRead = hObj;
	hObj = m_WritePipe.Detach();
	if( hWrite != nullptr ) *hWrite = hObj;
	return TRUE;
}

/**********************************************************************//**
 *
 * 쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	lpAttribute	= ZLeBLqq
 * @param [in]	dwSize		= pCṽobt@̃TCYi0w肷ƋKlɂȂj
 * @return	
*//***********************************************************************/
BOOL CPipe::Create(LPSECURITY_ATTRIBUTES lpAttribute, DWORD dwSize)
{
	HANDLE hRead, hWrite;
	if( !::CreatePipe(&hRead, &hWrite, lpAttribute, dwSize) ) return FALSE;

	if( !m_ReadPipe.Attach(hRead) )
	{
		CloseHandle(hRead);
		CloseHandle(hWrite);
		return FALSE;
	}
	if( !m_WritePipe.Attach(hWrite) )
	{
		CloseHandle(hRead);
		CloseHandle(hWrite);
		return FALSE;
	}
	return TRUE;
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
bool CPipe::Close(void)
{
	bool retR = m_ReadPipe.Close();
	bool retW = m_WritePipe.Close();
	return retR && retW;
}

}	// end of namespace wx
}	// end of namespace iris


#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "../../unit/UnitCore.h"
#include "../os/WXProcess.h"
#include "../../iris_using.h"
#include "../../iris_iostream.h"

//======================================================================
// test
IRIS_UNITTEST(CWXPipe, Process)
{
	CHAR cmd[256];
	std::cout << "> ";
	std::safe_cin >> cmd;
	std::string argv = cmd;
	while(1)
	{
		if( std::safe_cin.peek() == 0x0a )
		{
			break;
		}
		std::cin >> cmd;
		argv += " ";
		argv += cmd;
	}

	SECURITY_ATTRIBUTES securityAttr;
	ZeroMemory( &securityAttr, sizeof(securityAttr) );
	securityAttr.nLength = sizeof(securityAttr);
	securityAttr.bInheritHandle = TRUE;
	securityAttr.lpSecurityDescriptor = NULL;

	CPipe pipeOutput;
	CPipe pipeInput;
	CPipe pipeError;

	pipeOutput.Create(&securityAttr);
	pipeInput.Create(&securityAttr);
	pipeError.Create(&securityAttr);

	{
		CProcess proc;
		CStartupInfoA si;
		si.GetSelf();
		si.UseStdHandles(pipeOutput.GetWritePipe(), pipeInput.GetReadPipe(), pipeError.GetWritePipe());
		proc.Create<CHAR>(nullptr, (LPSTR)argv.c_str(), &securityAttr, nullptr
			, TRUE, DEBUG_PROCESS, nullptr, nullptr, si, nullptr);

		pipeInput.GetWritePipe().Write("test", 5);
		proc.Join();
	}
}

#endif
