//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXFindFile.cpp
 * @brief		t@CNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXFindFile_CPP_

//======================================================================
// include
#include "WXFindFile.h"

namespace iris {
namespace wx
{

//======================================================================
// class
// CTFindFile
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
template<typename CHARTYPE_>
CTFindFile<CHARTYPE_>::CTFindFile(void)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
template<typename CHARTYPE_>
CTFindFile<CHARTYPE_>::~CTFindFile(void)
{
	Close();
}

/**********************************************************************//**
 *
 * 擪
 *
 ----------------------------------------------------------------------
 * @param [in]	lpFileName	= t@CpX
 * @return	
*//***********************************************************************/
template<>
BOOL CTFindFile<CHAR>::FindFirst(LPCSTR lpFileName)
{
#if !defined(IRIS_WIN32_WCE)
	Close();
	HANDLE hdle = FindFirstFileA(lpFileName, &m_FindData);
	if( hdle == INVALID_HANDLE_VALUE ) return FALSE;
	return Attach(hdle);
#else
	return FALSE;
#endif
}
template<>
BOOL CTFindFile<WCHAR>::FindFirst(LPCWSTR lpFileName)
{
	Close();
	HANDLE hdle = FindFirstFileW(lpFileName, &m_FindData);
	if( hdle == INVALID_HANDLE_VALUE ) return FALSE;
	return Attach(hdle);
}

/**********************************************************************//**
 *
 * 擪
 *
 ----------------------------------------------------------------------
 * @param [in]	lpFileName			= t@CpX
 * @param [in]	fInfoLevelId		= f[^̏񃌃x
 * @param [in]	fSearchOp			= stB^̃^Cv
 * @param [in]	lpSearchFilter		= ւ̃|C^
 * @param [in]	dwAdditionalFlags	= ⑫IȌtO
 * @return	
*//***********************************************************************/
#if	(_WIN32_WINNT >= 0x0400)
template<>
BOOL CTFindFile<CHAR>::FindFirstEx(LPCSTR lpFileName, FINDEX_INFO_LEVELS fInfoLevelId, FINDEX_SEARCH_OPS fSearchOp
								   , LPVOID lpSearchFilter, DWORD dwAdditionalFlags)
{
#if !defined(IRIS_WIN32_WCE) && IRIS_MSC_AT_LEAST(_MSC_VER_VC8)
	Close();
	HANDLE hdle = FindFirstFileExA(lpFileName, fInfoLevelId, &m_FindData, fSearchOp, lpSearchFilter, dwAdditionalFlags);
	if( hdle == INVALID_HANDLE_VALUE ) return FALSE;
	return Attach(hdle);
#else
	return FindFirst(lpFileName);
#endif
}
template<>
BOOL CTFindFile<WCHAR>::FindFirstEx(LPCWSTR lpFileName, FINDEX_INFO_LEVELS fInfoLevelId, FINDEX_SEARCH_OPS fSearchOp
								  , LPVOID lpSearchFilter, DWORD dwAdditionalFlags)
{
#if IRIS_MSC_AT_LEAST(_MSC_VER_VC8)
	Close();
	HANDLE hdle = FindFirstFileExW(lpFileName, fInfoLevelId, &m_FindData, fSearchOp, lpSearchFilter, dwAdditionalFlags);
	if( hdle == INVALID_HANDLE_VALUE ) return FALSE;
	return Attach(hdle);
#else
	return FindFirst(lpFileName);
#endif
}
#endif

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @return	t@Cnh
*//***********************************************************************/
template<>
BOOL CTFindFile<CHAR>::FindNext(void)
{
#if !defined(IRIS_WIN32_WCE)
	return FindNextFileA(m_hObject, &m_FindData);
#else
	return FALSE;
#endif
}
template<>
BOOL CTFindFile<WCHAR>::FindNext(void)
{
	return FindNextFileW(m_hObject, &m_FindData);
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
template<typename CHARTYPE_>
bool CTFindFile<CHARTYPE_>::Close(void)
{
	return IRIS_TO_bool( FindClose(Detach()) );
}

template class CTFindFile<CHAR>;
template class CTFindFile<WCHAR>;

}	// end of namespace wx
}	// end of namespace iris
