//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXDevice.h
 * @brief		WXDevice t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 *
 * @par			copyright
 * Copyright (C) 2010 t.sirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXDevice_H_
#define INCG_IRIS_WXDevice_H_

//======================================================================
// include
#include "WXHFile.h"
#include "fnd/io/FndDeviceIO.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/// Device NX
class CDevice : public CHFile, public fnd::IDeviceIO
{
public:
	// RXgN^
	CDevice(void);

public:
	BOOL	DeviceIoControl(DWORD dwIoControlCode, LPVOID lpInBuffer, DWORD nInBufferSize
						, LPVOID lpOutBuffer, DWORD nOutBufferSize, LPDWORD lpBytesReturned, LPOVERLAPPED lpOverlapped) const;

protected:
	// 
	bool	OnIoControl(u32 dwIoControlCode, LPVOID lpInBuffer, u32 nInBufferSize
						, LPVOID lpOutBuffer, u32 nOutBufferSize, u32* lpBytesReturned) const
	{
		return IRIS_TO_bool(DeviceIoControl(dwIoControlCode, lpInBuffer, nInBufferSize, lpOutBuffer, nOutBufferSize, lpBytesReturned, nullptr));
	}
};

}	// end of namespace wx
}	// end of namespace iris

#endif
