//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXComPort.cpp
 * @brief		Communication Port t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXComPort_CPP_

//======================================================================
// include
#include "WXComPort.h"
#include "iris_debug.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CComPort::CComPort(void)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CComPort::~CComPort(void)
{
	//Break();
}

/**********************************************************************//**
 *
 * J
 *
 ----------------------------------------------------------------------
 * @param [in]	nPortNo					= |[gԍ
 * @param [in]	dwFlagsAndAttributes	= t@C(FILE_ATTRIBUTE_***)
 * @param [in]	dwDesiredAccess			= ANZX[h(GENERIC_*** or 0)
 * @param [in]	dwShareMode				= L[h(FILE_SHARE_*** or 0)
 * @return	
*//***********************************************************************/
BOOL CComPort::Open(int nPortNo, DWORD dwFlagsAndAttributes, DWORD dwDesiredAccess, DWORD dwShareMode)
{
	TCHAR name[32];
	wsprintf(name, IRIS_TEXT("COM%d"), nPortNo);
	return CHFile::Open(name, dwDesiredAccess, dwShareMode, nullptr
		, OPEN_EXISTING, dwFlagsAndAttributes, nullptr);
}

/**********************************************************************//**
 *
 * M
 *
 ----------------------------------------------------------------------
 * @param [in]	lpBuffer		= ݃obt@
 * @param [in]	dwSize			= obt@TCY
 * @param [out]	lpdwWritten		= 񂾃TCY
 * @param [in]	lpOverlapped	= I[obvݒ
 * @return	
*//***********************************************************************/
BOOL CComPort::Send(LPVOID lpBuffer, DWORD dwSize, LPDWORD lpdwWritten, LPOVERLAPPED lpOverlapped)
{
	return CHFile::Write(lpBuffer, dwSize, lpdwWritten, lpOverlapped);
}

/**********************************************************************//**
 *
 * M
 *
 ----------------------------------------------------------------------
 * @param [in]	lpBuffer		= ݃obt@
 * @param [in]	dwSize			= obt@TCY
 * @return	񂾃TCY
*//***********************************************************************/
DWORD CComPort::Send(LPVOID lpBuffer, DWORD dwSize)
{
	DWORD dwWritten=0;
	CHFile::Write(lpBuffer, dwSize, &dwWritten, nullptr);
	return dwWritten;
}

/**********************************************************************//**
 *
 * M
 *
 ----------------------------------------------------------------------
 * @param [out]	lpBuffer		= o̓obt@
 * @param [in]	dwSize			= obt@TCY
 * @param [out]	lpdwRead		= ǂݍ񂾃TCY
 * @param [in]	lpOverlapped	= I[obvݒ
 * @return	
*//***********************************************************************/
BOOL CComPort::Recv(LPVOID lpBuffer, DWORD dwSize, LPDWORD lpdwRead, LPOVERLAPPED lpOverlapped)
{
	return CHFile::Read(lpBuffer, dwSize, lpdwRead, lpOverlapped);
}

/**********************************************************************//**
 *
 * M
 *
 ----------------------------------------------------------------------
 * @param [out]	lpBuffer		= o̓obt@
 * @param [in]	dwSize			= obt@TCY
 * @return	ǂݍ񂾃TCY
*//***********************************************************************/
DWORD CComPort::Recv(LPVOID lpBuffer, DWORD dwSize)
{
	DWORD dwRead=0;
	CHFile::Read(lpBuffer, dwSize, &dwRead, nullptr);
	return dwRead;
}

/**********************************************************************//**
 *
 * f
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CComPort::Break(void)
{
	if( m_hObject == nullptr ) return FALSE;
	return SetCommBreak(m_hObject);
}

/**********************************************************************//**
 *
 * ؒfԂ̉
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CComPort::ClearBreak(void)
{
	if( m_hObject == nullptr ) return FALSE;
	return ClearCommBreak(m_hObject);
}

/**********************************************************************//**
 *
 * ʐM̉
 *
 ----------------------------------------------------------------------
 * @param [in]	dwFlags	= tO(PURGE_***)
 * @return	
*//***********************************************************************/
BOOL CComPort::Purge(DWORD dwFlags)
{
	if( m_hObject == nullptr ) return FALSE;
	return PurgeComm(m_hObject, dwFlags);
}

/**********************************************************************//**
 *
 * ʐMG[̎擾
 *
 ----------------------------------------------------------------------
 * @param [out]	lpError	= G[lo
 * @param [out]	lpStat	= 
 * @return	
*//***********************************************************************/
BOOL CComPort::ClearError(LPDWORD lpError, LPCOMSTAT lpStat)
{
	if( m_hObject == nullptr ) return FALSE;
	return ClearCommError(m_hObject, lpError, lpStat);
}

/**********************************************************************//**
 *
 * Ԃ̎擾
 *
 ----------------------------------------------------------------------
 * @param [out]	lpStat	= 
 * @return	
*//***********************************************************************/
BOOL CComPort::GetStat(LPCOMSTAT lpStat)	const
{
	if( m_hObject == nullptr ) return FALSE;
	return ClearCommError(m_hObject, nullptr, lpStat);
}

/**********************************************************************//**
 *
 * Ԃ̎擾
 *
 ----------------------------------------------------------------------
 * @param [out]	lpProp	= 
 * @return	
*//***********************************************************************/
BOOL CComPort::GetProperties(LPCOMMPROP lpProp)	const
{
	if( m_hObject == nullptr ) return FALSE;
	return GetCommProperties(m_hObject, lpProp);
}

/**********************************************************************//**
 *
 * \̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	lpConfig	= \
 * @return	
*//***********************************************************************/
BOOL CComPort::SetConfig(LPCOMMCONFIG lpConfig)
{
	if( lpConfig == nullptr ) return FALSE;
	if( m_hObject == nullptr ) return FALSE;
#if	!defined(IRIS_WIN32_WCE)
	return SetCommConfig(m_hObject, lpConfig, lpConfig->dwSize);
#else
	return FALSE;
#endif
}

/**********************************************************************//**
 *
 * |[gݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	lpDCB	= ݒ
 * @return	
*//***********************************************************************/
BOOL CComPort::SetState(LPDCB lpDCB)
{
	if( lpDCB == nullptr ) return FALSE;
	IRIS_ASSERT( lpDCB->DCBlength == sizeof(DCB) );
	if( m_hObject == nullptr ) return FALSE;
	return SetCommState(m_hObject, lpDCB);
}

/**********************************************************************//**
 *
 * |[gݒ̎擾
 *
 ----------------------------------------------------------------------
 * @param [out]	lpDCB	= ݒ
 * @return	
*//***********************************************************************/
BOOL CComPort::GetState(LPDCB lpDCB)	const
{
	if( lpDCB == nullptr ) return FALSE;
	if( m_hObject == nullptr ) return FALSE;
	return GetCommState(m_hObject, lpDCB);
}

/**********************************************************************//**
 *
 * }XNl̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	dwMask	= }XNl
 * @return	
*//***********************************************************************/
BOOL CComPort::SetMask(DWORD dwMask)
{
	if( m_hObject == nullptr ) return FALSE;
	return SetCommMask(m_hObject, dwMask);
}

/**********************************************************************//**
 *
 * }XNl̎擾
 *
 ----------------------------------------------------------------------
 * @return	}XNl
*//***********************************************************************/
DWORD CComPort::GetMask(void)	const
{
	DWORD dwMask = 0;
	if( m_hObject == nullptr ) return FALSE;
	GetCommMask(m_hObject, &dwMask);
	return dwMask;
}

/**********************************************************************//**
 *
 * ^CAEgԂ̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	lpTimeouts	= ݒi~bPʁj
 * @return	
*//***********************************************************************/
BOOL CComPort::SetTimeouts(LPCOMMTIMEOUTS lpTimeouts)
{
	if( lpTimeouts == nullptr ) return FALSE;
	if( m_hObject == nullptr ) return FALSE;
	return SetCommTimeouts(m_hObject, lpTimeouts);
}

/**********************************************************************//**
 *
 * ^CAEgԂ̎擾
 *
 ----------------------------------------------------------------------
 * @param [out]	lpTimeouts	= ݒ
 * @return	
*//***********************************************************************/
BOOL CComPort::GetTimeouts(LPCOMMTIMEOUTS lpTimeouts)	const
{
	if( lpTimeouts == nullptr ) return FALSE;
	if( m_hObject == nullptr ) return FALSE;
	return GetCommTimeouts(m_hObject, lpTimeouts);
}

}	// end of namespace wx
}	// end of namespace iris

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "unit/UnitCore.h"
#include "WXOverlapped.h"
#include "WXIOThread.h"
#include "iris_using.h"
#include "iris_iostream.h"

//======================================================================
// define
#define MODE_OVERLAPPED		1
#define MODE_EVENT			0

//======================================================================
// class
class CCOM1 : public CIOThread<CComPort>
{
protected:
	/// ǂݍݎ̏
	virtual void	OnRead(char* lpBuffer, DWORD dwSize, DWORD dwRead)
	{
		IRIS_UNUSED_VAR(dwSize);
		lpBuffer[dwRead] = '\0';
		printf(lpBuffer);
	}
};

//======================================================================
// test
IRIS_UNITTEST(CWXComPortUnitTest, Func)
{
	// COM1 J
	CCOM1 port;
#if MODE_OVERLAPPED
	if( !port.IO().Open(1, FILE_FLAG_OVERLAPPED) ) return;
#else
	if( !port.IO().Open(1) ) return 1;
#endif
	DCB dcb = {0};
	dcb.DCBlength = sizeof(DCB);
	dcb.BaudRate = CBR_115200;
	dcb.Parity = NOPARITY;
	dcb.ByteSize = 8;
	dcb.StopBits = ONESTOPBIT;
	const char text[] = "Hello Communication Port 1";
	char recv[256];
	if( !port.IO().SetState(&dcb) ) return;

	{
		COMMPROP prop;
		port.IO().GetProperties(&prop);
		std::cout << std::hex;
		std::cout << "wPacketLength " << prop.wPacketLength << std::endl;
		std::cout << "wPacketVersion " << prop.wPacketVersion << std::endl;
		std::cout << "dwServiceMask " << prop.dwServiceMask << std::endl;
		std::cout << "dwMaxTxQueue " << prop.dwMaxTxQueue << std::endl;
		std::cout << "dwMaxRxQueue " << prop.dwMaxRxQueue << std::endl;
		std::cout << "dwMaxBaud " << prop.dwMaxBaud << std::endl;
		std::cout << "dwProvSubType " << prop.dwProvSubType << std::endl;
		std::cout << "dwProvCapabilities " << prop.dwProvCapabilities << std::endl;
		std::cout << "dwSettableParams " << prop.dwSettableParams << std::endl;
		std::cout << "dwSettableBaud " << prop.dwSettableBaud << std::endl;
		std::cout << "wSettableData " << prop.wSettableData << std::endl;
		std::cout << "wSettableStopParity " << prop.wSettableStopParity << std::endl;
		std::cout << "dwCurrentTxQueue " << prop.dwCurrentTxQueue << std::endl;
		std::cout << "dwCurrentRxQueue " << prop.dwCurrentRxQueue << std::endl;
		std::cout << "dwProvSpec1 " << prop.dwProvSpec1 << std::endl;
		std::cout << "dwProvSpec2 " << prop.dwProvSpec2 << std::endl;
		std::cout << "wcProvChar " << prop.wcProvChar << std::endl;
	}

#if MODE_OVERLAPPED
	dprintf(IRIS_TEXT("send\n"));
	{
		COverlapped ovl;
		ovl.Create(nullptr, TRUE, FALSE);
		ovl.AttachEvent();
		DWORD dwWritten=0;
		if( !port.IO().Send((void*)text, sizeof(text), &dwWritten, &ovl.GetOverlapped()) )
		{
			if( GetLastError() == ERROR_IO_PENDING )
			{
				port.IO().GetOverlappedResult(&ovl.GetOverlapped(), &dwWritten, TRUE);
			}
		}
		ovl.ResetSignal();
		ovl.Close();
	}

	dprintf(IRIS_TEXT("recv\n"));
	dprintf(IRIS_TEXT("When something is input, it stops.\n"));
	port.CreateStart();	// MXbhJn
	std::safe_cin.clear();
	std::safe_cin >> recv;
	port.Terminate();
#else
	dprintf(IRIS_TEXT("send\n"));
	port.Send((void*)text, sizeof(text));

	dprintf(IRIS_TEXT("recv\n"));
	while(1)
	{
		COMSTAT stat;
		port.GetStat(&stat);
		if( stat.cbInQue == 0 ) break;

		DWORD read = port.Recv(recv, stat.cbInQue);
		recv[read] = '\0';
		dprintf(recv);

		Sleep(1);
	}
	puts("");
#endif
}

#endif	// #if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
