//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXClipboardFile.cpp
 * @brief		Nbv{[ht@Co t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXClipboardFile_CPP_

//======================================================================
// include
#include "WXClipboardFile.h"
#include "WXClipboard.h"
#include "../memory/WXGlobalMemory.h"

namespace iris {
namespace wx
{

//======================================================================
// class

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CClipboardFile::CClipboardFile(void)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CClipboardFile::~CClipboardFile(void)
{
}

/**********************************************************************//**
 *
 * VACY
 *
 -----------------------------------------------------------------------
 * @param [in]	uFormat	= Nbv{[h̎
 * @return	
*//***********************************************************************/
bool CClipboardFile::Serialize(UINT uFormat)
{
	if( !IsValid() ) return false;
	CClipboard cb;
	if( !cb.Open(nullptr) ) return false;

	DWORD dwWritten = 0;
	CGlobalMemory gmem;
	gmem = cb.GetData(uFormat);
	LPVOID buf = gmem.Lock();
	Write(buf, (DWORD)gmem.GetSize(), &dwWritten);
	gmem.Unlock();
	gmem.Detach();
	return true;
}

/**********************************************************************//**
 *
 * fVACY
 *
 -----------------------------------------------------------------------
 * @param [in]	uFormat	= Nbv{[h̎
 * @return	
*//***********************************************************************/
bool CClipboardFile::Deserialize(UINT uFormat)
{
	if( !IsValid() ) return false;
	CClipboard cb;
	if( !cb.Open(nullptr) ) return false;

	CGlobalMemory gmem;
	DWORD dwRead = 0;
	DWORD size = GetSize();
	if( !gmem.Alloc(GHND, size) ) return false;
	LPVOID buf = gmem.Lock();
	Read(buf, size, &dwRead);
	gmem.Unlock();

	cb.SetData(uFormat, gmem);
	gmem.Detach();
	return true;
}


}	// end of namespace wx
}	// end of namespace iris
