//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXGopher.cpp
 * @brief		GopherNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXGopher_CPP_

//======================================================================
// include
#include "WXGopher.h"

//======================================================================
#pragma comment ( lib, "wininet.lib" )

namespace iris {
namespace wx
{

//======================================================================
// class

//======================================================================
// CGopherLocator
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CGopherLocator::CGopherLocator(void)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CGopherLocator::~CGopherLocator(void)
{
}

/**********************************************************************//**
 *
 *
 *
 ----------------------------------------------------------------------
 * @param [in]	lpszHost			= zXg
 * @param [in]	nServerPort			= T[o[|[gԍ(0=ftHg)
 * @param [in]	lpszDisplayString	= 
 * @param [in]	lpszSelectorString	= 
 * @param [in]	dwGopherType		= 
 * @return	
*//***********************************************************************/
BOOL CGopherLocator::Create (LPCTSTR lpszHost, INTERNET_PORT nServerPort, LPCTSTR lpszDisplayString, LPCTSTR lpszSelectorString, DWORD dwGopherType)
{
#ifdef UNICODE
	return CreateW(lpszHost, nServerPort, lpszDisplayString, lpszSelectorString, dwGopherType);
#else
	return CreateA(lpszHost, nServerPort, lpszDisplayString, lpszSelectorString, dwGopherType);
#endif
}
/// CGopherLocator::Create Q
BOOL CGopherLocator::CreateA(LPCSTR  lpszHost, INTERNET_PORT nServerPort, LPCSTR  lpszDisplayString, LPCSTR  lpszSelectorString, DWORD dwGopherType)
{
#if	!defined(IRIS_WIN32_WCE)
	DWORD dwSize = 0;
	if( !GopherCreateLocatorA(lpszHost, nServerPort, lpszDisplayString, lpszSelectorString, dwGopherType, nullptr, &dwSize) ) return FALSE;
	if( dwSize == 0 ) return FALSE;
	Alloc( dwSize );
	return GopherCreateLocatorA(lpszHost, nServerPort, lpszDisplayString, lpszSelectorString, dwGopherType, (LPSTR) GetAddr(), &dwSize);
#else
	return FALSE;
#endif
}
/// CGopherLocator::Create Q
BOOL CGopherLocator::CreateW(LPCWSTR lpszHost, INTERNET_PORT nServerPort, LPCWSTR lpszDisplayString, LPCWSTR lpszSelectorString, DWORD dwGopherType)
{
#if	!defined(IRIS_WIN32_WCE) || defined(UNDER_NT)
	DWORD dwSize = 0;
	if( !GopherCreateLocatorW(lpszHost, nServerPort, lpszDisplayString, lpszSelectorString, dwGopherType, nullptr, &dwSize) ) return FALSE;
	if( dwSize == 0 ) return FALSE;
	Alloc( dwSize );
	return GopherCreateLocatorW(lpszHost, nServerPort, lpszDisplayString, lpszSelectorString, dwGopherType, (LPWSTR)GetAddr(), &dwSize);
#else
	return FALSE;
#endif
}

//======================================================================
// CGopher
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CGopher::CGopher(void)
{
}

/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	hConnect		= ֘Atnh
*//***********************************************************************/
CGopher::CGopher(HINTERNET hConnect)
: CInternet(hConnect)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CGopher::~CGopher(void)
{
}

/**********************************************************************//**
 *
 * t@CJ
 *
 ----------------------------------------------------------------------
 * @param [in]	lpszLocator		= 
 * @param [in]	lpszView		= 
 * @param [in]	dwFlags			= tO((FTP_TRANSFER_TYPE_*** or INTERNET_FLAG_***))
 * @param [in]	dwContext		= R[obN֐ɓnl
 * @return	nh
*//***********************************************************************/
HINTERNET CGopher::OpenFile (LPCTSTR lpszLocator, LPCTSTR lpszView, DWORD dwFlags, DWORD_PTR dwContext)
{
#if	defined(UNICODE)
	return OpenFileW(lpszLocator, lpszView, dwFlags, dwContext);
#else
	return OpenFileA(lpszLocator, lpszView, dwFlags, dwContext);
#endif
}
/// CGopher::OpenFile Q
HINTERNET CGopher::OpenFileA(LPCSTR  lpszLocator, LPCSTR  lpszView, DWORD dwFlags, DWORD_PTR dwContext)
{
#if	!defined(IRIS_WIN32_WCE)
	return ::GopherOpenFileA(m_hInternet, lpszLocator, lpszView, dwFlags, dwContext);
#else
	return FALSE;
#endif
}
/// CGopher::OpenFile Q
HINTERNET CGopher::OpenFileW(LPCWSTR lpszLocator, LPCWSTR lpszView, DWORD dwFlags, DWORD_PTR dwContext)
{
#if	!defined(IRIS_WIN32_WCE) || defined(UNDER_NT)
	return ::GopherOpenFileW(m_hInternet, lpszLocator, lpszView, dwFlags, dwContext);
#else
	return FALSE;
#endif
}

/**********************************************************************//**
 *
 *
 *
 ----------------------------------------------------------------------
 * @param [in]	lpszLocator			= 
 * @param [in]	lpszAttributeName	= 
 * @param [in]	lpBuffer			= 
 * @param [in]	dwBufferLength		= obt@
 * @param [in]	lpdwReturned		= 
 * @param [in]	lpfnEnumerator		= 
 * @param [in]	dwContext			= 
 * @return	
*//***********************************************************************/
BOOL CGopher::GetAttribute (LPCTSTR lpszLocator, LPCTSTR lpszAttributeName, LPBYTE lpBuffer, DWORD dwBufferLength, LPDWORD lpdwReturned
				, GOPHER_ATTRIBUTE_ENUMERATOR lpfnEnumerator, DWORD_PTR dwContext)
{
#if	defined(UNICODE)
	return GetAttributeW(lpszLocator, lpszAttributeName, lpBuffer, dwBufferLength, lpdwReturned
		, lpfnEnumerator, dwContext);
#else
	return GetAttributeA(lpszLocator, lpszAttributeName, lpBuffer, dwBufferLength, lpdwReturned
		, lpfnEnumerator, dwContext);
#endif
}
/// CGopher::GetAttribute Q
BOOL CGopher::GetAttributeA(LPCSTR  lpszLocator, LPCSTR  lpszAttributeName, LPBYTE lpBuffer, DWORD dwBufferLength, LPDWORD lpdwReturned
				, GOPHER_ATTRIBUTE_ENUMERATOR lpfnEnumerator, DWORD_PTR dwContext)
{
#if	!defined(IRIS_WIN32_WCE)
	return ::GopherGetAttributeA(m_hInternet, lpszLocator, lpszAttributeName, lpBuffer, dwBufferLength, lpdwReturned
		, lpfnEnumerator, dwContext);
#else
	return FALSE;
#endif
}
/// CGopher::GetAttribute Q
BOOL CGopher::GetAttributeW(LPCWSTR lpszLocator, LPCWSTR lpszAttributeName, LPBYTE lpBuffer, DWORD dwBufferLength, LPDWORD lpdwReturned
				, GOPHER_ATTRIBUTE_ENUMERATOR lpfnEnumerator, DWORD_PTR dwContext)
{
#if	!defined(IRIS_WIN32_WCE) || defined(UNDER_NT)
	return ::GopherGetAttributeW(m_hInternet, lpszLocator, lpszAttributeName, lpBuffer, dwBufferLength, lpdwReturned
		, lpfnEnumerator, dwContext);
#else
	return FALSE;
#endif
}

}	// end of namespace wx
}	// end of namespace iris
