//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXIconImage.cpp
 * @brief		icon C[WNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXIconImage_CPP_

//======================================================================
// include
#include "WXIconImage.h"
#include "fnd/memory/FndMemory.h"
#include "iris_debug.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CIconImage::CIconImage(void)
: m_pBuffer(nullptr)
{
	m_Image.pBmpInfo	= nullptr;
	m_Image.pPalette	= nullptr;
	m_Image.pXOR		= nullptr;
	m_Image.pAND		= nullptr;
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CIconImage::~CIconImage(void)
{
	Release();
}

/**********************************************************************//**
 *
 * t@Cǂݍ
 *
 -----------------------------------------------------------------------
 * @param [in]	lpFile	= t@CNX
 * @param [in]	nIndex	= CfbNX
 * @return	
*//***********************************************************************/
bool CIconImage::ReadFile(const CIconFile* lpFile, int nIndex)
{
	if( lpFile == nullptr ) return false;
	if( lpFile->GetAddr() == nullptr ) return false;
	ICONIMAGE image;
	lpFile->GetImage(nIndex, &image);
	return ReadOnMemory(&image);
}

/**********************************************************************//**
 *
 * obt@ǂݍ
 *
 -----------------------------------------------------------------------
 * @param [in]	lpBuffer	= ̓obt@
 * @param [in]	nIndex	= CfbNX
 * @return	
*//***********************************************************************/
bool CIconImage::ReadOnMemory(const void* lpBuffer, int nIndex)
{
	// TODO : T|[g
	IRIS_UNUSED_VARIABLE(lpBuffer);
	IRIS_UNUSED_VARIABLE(nIndex);
	return false;
}

/**********************************************************************//**
 *
 * ACRC[W񂩂ǂݍ
 *
 -----------------------------------------------------------------------
 * @param [in]	lpIconImage	= ̓obt@
 * @return	
*//***********************************************************************/
bool CIconImage::ReadOnMemory(const LPICONIMAGE lpIconImage)
{
	if( lpIconImage == nullptr ) return false;
	Release();
	m_Image = *lpIconImage;
	return true;
}

/**********************************************************************//**
 *
 * obt@̊m
 *
 -----------------------------------------------------------------------
 * @param [in]	size	= mۂTCY
 * @return	
*//***********************************************************************/
bool CIconImage::Alloc(u32 size)
{
	if( m_pBuffer != nullptr )
	{
		IRIS_WARNING("data was allocated.");
		Release();
	}
	u8* data = static_cast<u8*>(irisAlloc(size, 0));
	if( data == nullptr ) return false;
	m_pBuffer	= data;
	m_Image.pBmpInfo = pointer_cast<fnd::LPBMPINFOHEADER>(data);
	return true;
}

/**********************************************************************//**
 *
 * obt@̉
 *
*//***********************************************************************/
void CIconImage::Release(void)
{
	if( m_pBuffer != nullptr )
	{
		m_pBuffer = nullptr;
		irisFree(m_pBuffer);
	}
	m_Image.pBmpInfo	= nullptr;
	m_Image.pPalette	= nullptr;
	m_Image.pXOR		= nullptr;
	m_Image.pAND		= nullptr;
}

/**********************************************************************//**
 *
 * ACRC[W̍쐬
 *
 -----------------------------------------------------------------------
 * @param [in]	nBitCount	= rbg[x
 * @param [in]	nWidht		= 
 * @param [in]	nHeight		= 
 * @return	
*//***********************************************************************/
bool CIconImage::Create(u16 nBitCount, s32 nWidth, s32 nHeight)
{
	Release();
	u32 size = 0;
	u32 mask = IRIS_RoundUp4B((nWidth+7)>>3) * nHeight;
	u32 clr = 0;
	switch(nBitCount)
	{
	case 1:
		clr = 2;
		size = IRIS_RoundUp4B((nWidth+7)>>3) * nHeight;
		break;
	case 4:
		clr = 16;
		size = IRIS_RoundUp4B((nWidth+1)>>1) * nHeight;
		break;
	case 8:
		clr = 256;
		size = IRIS_RoundUp4B(nWidth) * nHeight;
		break;
	case 16:
		clr = 65536;
		size = IRIS_RoundUp4B(nWidth*2) * nHeight;
		break;
	case 24:
		size = IRIS_RoundUp4B(nWidth*3) * nHeight;
		break;
	case 32:
		size = IRIS_RoundUp4B(nWidth*4) * nHeight;
		break;
	default:
		return false;;
	}

	u32 plsize = sizeof(IrisRGBQUAD)*clr;
	if( !Alloc(size + mask + sizeof(fnd::BMPINFOHEADER) + plsize) ) return false;
	u8* data = m_pBuffer + sizeof(fnd::BMPINFOHEADER);
	m_Image.pPalette	= clr ? pointer_cast<IrisRGBQUAD*>(data) : nullptr;
	m_Image.pXOR		= data + plsize;
	m_Image.pAND		= m_Image.pXOR + size;

	m_Image.pBmpInfo->biSize			= sizeof(fnd::BMPINFOHEADER);
	m_Image.pBmpInfo->biBitCount		= nBitCount;
	m_Image.pBmpInfo->biPlanes			= 1;
	m_Image.pBmpInfo->biClrImportant	= 0;
	m_Image.pBmpInfo->biClrUsed			= clr;
	m_Image.pBmpInfo->biXPelsPerMeter	= 0;
	m_Image.pBmpInfo->biYPelsPerMeter	= 0;
	m_Image.pBmpInfo->biCompression		= 0;
	m_Image.pBmpInfo->biWidth			= nWidth;
	m_Image.pBmpInfo->biHeight			= nHeight<<1;
	m_Image.pBmpInfo->biSizeImage		= size;
	return true;
}

/**********************************************************************//**
 *
 * ACRC[W̃Rs[
 *
 -----------------------------------------------------------------------
 * @param [in]	rIconImage	= Rs[ACRC[W
 * @return	
*//***********************************************************************/
bool CIconImage::Duplicate(CIconImage& rIconImage)
{
	if( !rIconImage.IsValid() ) return false;
	u32 size = rIconImage.GetBufferSize();
	if( !Alloc(size) ) return false;
	memcpy(m_pBuffer, rIconImage.m_Image.pBmpInfo, size);

	u8* data = m_pBuffer + m_Image.pBmpInfo->biSize;
	m_Image.pPalette= m_Image.pBmpInfo->biClrUsed ? pointer_cast<IrisRGBQUAD*>(data) : nullptr;
	m_Image.pXOR	= data + m_Image.pBmpInfo->biClrUsed * sizeof(RGBQUAD);
	m_Image.pAND	= m_Image.pXOR + m_Image.pBmpInfo->biSizeImage;
	return true;
}

/**********************************************************************//**
 *
 * obt@Rs[
 *
 -----------------------------------------------------------------------
 * @param [in]	lpIconImage	= ̓obt@
 * @return	
*//***********************************************************************/
bool CIconImage::DuplicateOnMemory(const LPICONIMAGE lpIconImage)
{
	IRIS_ASSERT( lpIconImage != nullptr );
	fnd::LPBMPINFOHEADER pbi = lpIconImage->pBmpInfo;
	u32 size = pbi->biSize;
	size += pbi->biClrUsed * sizeof(IrisRGBQUAD);
	size += pbi->biSizeImage;
	size += CIconFile::GetMaskSize(pbi);
	if( !Alloc(size) ) return false;
	memcpy(m_pBuffer, pbi, size);

	u8* data = m_pBuffer + pbi->biSize;
	m_Image.pPalette= pbi->biClrUsed ? pointer_cast<IrisRGBQUAD*>(data) : nullptr;
	m_Image.pXOR	= data + pbi->biClrUsed * sizeof(RGBQUAD);
	m_Image.pAND	= m_Image.pXOR + pbi->biSizeImage;
	return true;
}

/**********************************************************************//**
 *
 * wb_ɏ]ĕϊRs[
 *
 -----------------------------------------------------------------------
 * @param [in]	rBitmap	= Rs[rbg}bv
 * @return	
*//***********************************************************************/
bool CIconImage::Transfer(CIconImage& rIconImage)
{
	if( &rIconImage == this ) return false;
	if( !IsValid() ) return false;
	if( !rIconImage.IsValid() ) return false;
	ICONIMAGE& rImage = rIconImage.m_Image;
	fnd::LPBMPINFOHEADER pdbi = m_Image.pBmpInfo;
	fnd::LPBMPINFOHEADER psbi = rImage.pBmpInfo;
	u16 dbit = pdbi->biBitCount;
	u16 sbit = psbi->biBitCount;
	s32 dw = pdbi->biWidth;
	s32 dh = pdbi->biHeight>>1;
	s32 sw = psbi->biWidth;
	s32 sh = psbi->biHeight>>1;
	s32 tw = dw;
	s32 th = dh;
	if( tw > sw ) tw = sw;
	if( th > sh ) th = sh;
	u32 ofs = 0;
	u32 maskofs = IRIS_RoundUp4B((sw+7)>>3);
	int i=0;
	if( !IsSupportedBitCoount(dbit) ) return false;

	// XOR
	switch( sbit )
	{
	case 1:
		ofs = IRIS_RoundUp4B((sw+7)>>3);
		switch( dbit )
		{
		case 1:
			{
				for(i=0; i < 2; ++i)
					m_Image.pPalette[i] = rImage.pPalette[i];
				for(s32 h=0; h < th; ++h )
				{
					memcpy(m_Image.pXOR + IRIS_RoundUp4B((dw+7)>>3)*(dh-h-1)
						, rImage.pXOR + ofs * (sh-h-1), IRIS_RoundUp4B((tw+7)>>3));
				}
			}
			break;
		case 4:
			{
				for(i=0; i < 2; ++i)
					m_Image.pPalette[i] = rImage.pPalette[i];
				for(s32 h=0; i < th; ++h)
				{
					u8*	inpx = rImage.pXOR + ofs * (sh-h-1);
					u8* otpx = m_Image.pXOR + IRIS_RoundUp4B((dw+1)>>1) * (dh-h-1);
					for(s32 w=0; w < tw; )
					{
						for(i=0; i < 8 && w < tw; ++i, ++w)
						{
							int p1 = (*inpx & (0x01 << i)) >> i;
							++i;
							int p2 = 0;
							if( w+i < tw )	p2 = (*inpx & (0x01 << i)) >> i;
							*otpx = ((p1 << 4) & 0xF0) | (p2 & 0x0F);
							++otpx;
						}
						++inpx;
					}
				}
			}
			break;
		case 8:
			{
				for(i=0; i < 2; ++i)
					m_Image.pPalette[i] = rImage.pPalette[i];
				for(s32 h=0; h < th; ++h)
				{
					u8*	inpx = rImage.pXOR + ofs * (sh-h-1);
					u8* otpx = m_Image.pXOR + IRIS_RoundUp4B(dw) * (dh-h-1);
					for(s32 w=0; w < tw; )
					{
						for(i=0; i < 8 && w < tw; ++i, ++w)
						{
							u8 p1 = (u8)((*inpx & (0x01 << i)) >> i);
							*otpx = p1;
							++otpx;
						}
						++inpx;
					}
				}
			}
			break;
		case 16:
			{
				for(i=0; i < 2; ++i)
					m_Image.pPalette[i] = rImage.pPalette[i];
				for(s32 h=0; h < th; ++h)
				{
					u8*	inpx = rImage.pXOR + ofs * (sh-h-1);
					u16* otpx = (u16*)(m_Image.pXOR + IRIS_RoundUp4B(dw*2) * (dh-h-1));
					for(s32 w=0; w < tw;)
					{
						for(i=0; i < 8 && w < tw; ++i, ++w)
						{
							u16 p1 = (u16)((*inpx & (0x01 << i)) >> i);
							*otpx = p1;
							++otpx;
						}
						++inpx;
					}
				}
			}
			break;
		case 24:
			{
				for(s32 h=0; h < th; ++h)
				{
					u8*	inpx = rImage.pXOR + ofs * (sh-h-1);
					IrisBGR888* otpx = (IrisBGR888*)(m_Image.pXOR + IRIS_RoundUp4B(dw*3) * (dh-h-1));
					for(s32 w=0; w < tw; )
					{
						for(i=0; i < 8 && w < tw; ++i, ++w)
						{
							int p1 = (*inpx & (0x01 << i)) >> i;
							otpx->b = rImage.pPalette[p1].b;
							otpx->g = rImage.pPalette[p1].g;
							otpx->r = rImage.pPalette[p1].r;
							++otpx;
						}
						++inpx;
					}
				}
			}
			break;
		case 32:
			{
				for(s32 h=0; h < th; ++h)
				{
					u8*	inpx = rImage.pXOR + ofs * (sh-h-1);
					IrisRGBQUAD* otpx = (IrisRGBQUAD*)(m_Image.pXOR + IRIS_RoundUp4B(dw*4) * (dh-h-1));
					for(s32 w=0; w < tw; )
					{
						for(i=0; i < 8 && w < tw; ++i, ++w)
						{
							int p1 = (*inpx & (0x01 << i)) >> i;
							*otpx = rImage.pPalette[p1];
							++otpx;
						}
						++inpx;
					}
				}
			}
			break;
		default:
			return false;
		}
		break;
	case 4:
		ofs = IRIS_RoundUp4B((sw+1)>>1);
		switch( dbit )
		{
		//case 1:
		//	break;
		case 4:
			{
				for(i=0; i < 16; ++i)
					m_Image.pPalette[i] = rImage.pPalette[i];
				for(s32 h=0; h < th; ++h )
				{
					memcpy(m_Image.pXOR + IRIS_RoundUp4B((dw+1)>>1)*(dh-h-1)
						, rImage.pXOR + ofs * (sh-h-1), IRIS_RoundUp4B((tw+1)>>1));
				}
			}
			break;
		case 8:
			{
				for(i=0; i < 16; ++i)
					m_Image.pPalette[i] = rImage.pPalette[i];
				for(s32 h=0; h < th; ++h)
				{
					u8*	inpx = rImage.pXOR + ofs * (sh-h-1);
					u8* otpx = m_Image.pXOR + IRIS_RoundUp4B(dw) * (dh-h-1);
					for(s32 w=0; w < tw; )
					{
						for(i=0; i < 2 && w < tw; ++i, ++w)
						{
							u8 p1 = (u8)((*inpx & (0x0F << (i<<2))) >> (i<<2));
							*otpx = p1;
							++otpx;
						}
						++inpx;
					}
				}
			}
			break;
		case 16:
			{
				for(i=0; i < 16; ++i)
					m_Image.pPalette[i] = rImage.pPalette[i];
				for(s32 h=0; h < th; ++h)
				{
					u8*	inpx = rImage.pXOR + ofs * (sh-h-1);
					u16* otpx = (u16*)(m_Image.pXOR + IRIS_RoundUp4B(dw*2) * (dh-h-1));
					for(s32 w=0; w < tw; )
					{
						for(i=0; i < 2 && w < tw; ++i, ++w)
						{
							u16 p1 = (u16)((*inpx & (0x0F << (i<<2))) >> (i<<2));
							*otpx = p1;
							++otpx;
						}
						++inpx;
					}
				}
			}
			break;
		case 24:
			{
				for(s32 h=0; h < th; ++h)
				{
					u8*	inpx = rImage.pXOR + ofs * (sh-h-1);
					IrisBGR888* otpx = (IrisBGR888*)(m_Image.pXOR + IRIS_RoundUp4B(dw*3) * (dh-h-1));
					for(s32 w=0; w < tw; ++w)
					{
						for(i=0; i < 2 && w < tw; ++i, ++w)
						{
							int p1 = (*inpx & (0x0F << (i<<2))) >> (i<<2);
							otpx->b = rImage.pPalette[p1].b;
							otpx->g = rImage.pPalette[p1].g;
							otpx->r = rImage.pPalette[p1].r;
							++otpx;
						}
						++inpx;
					}
				}
			}
			break;
		case 32:
			{
				for(s32 h=0; h < th; ++h)
				{
					u8*	inpx = rImage.pXOR + ofs * (sh-h-1);
					IrisRGBQUAD* otpx = (IrisRGBQUAD*)(m_Image.pXOR + IRIS_RoundUp4B(dw*4) * (dh-h-1));
					for(s32 w=0; w < tw; ++w)
					{
						for(i=0; i < 2 && w < tw; ++i, ++w)
						{
							int p1 = (*inpx & (0x0F << (i<<2))) >> (i<<2);
							*otpx = rImage.pPalette[p1];
							++otpx;
						}
						++inpx;
					}
				}
			}
			break;
		default:
			return false;
		}
		break;
	case 8:
		ofs = IRIS_RoundUp4B(sw);
		switch( dbit )
		{
		//case 1:
		//	break;
		//case 4:
		//	break;
		case 8:
			{
				for(i=0; i < 256; ++i )
					m_Image.pPalette[i] = rImage.pPalette[i];
				for(s32 h=0; h < th; ++h )
				{
					memcpy(m_Image.pXOR+ IRIS_RoundUp4B(dw)*(dh-h-1)
						, rImage.pXOR + ofs * (sh-h-1), IRIS_RoundUp4B(tw));
				}
			}
			break;
		case 16:
			{
				for(i=0; i < 256; ++i )
					m_Image.pPalette[i] = rImage.pPalette[i];
				for(s32 h=0; h < th; ++h)
				{
					u8*	inpx = rImage.pXOR + ofs * (sh-h-1);
					u16* otpx = (u16*)(m_Image.pXOR + IRIS_RoundUp4B(dw*2) * (dh-h-1));
					for(s32 w=0; w < tw; ++w)
					{
						u16 p1 = *inpx;
						*otpx = p1;
						++otpx;
						++inpx;
					}
				}
			}
			break;
		case 24:
			{
				for(s32 h=0; h < th; ++h)
				{
					u8*	inpx = rImage.pXOR + ofs * (sh-h-1);
					IrisBGR888* otpx = (IrisBGR888*)(m_Image.pXOR + IRIS_RoundUp4B(dw*3) * (dh-h-1));
					for(s32 w=0; w < tw; ++w)
					{
						int p1 = *inpx;
						otpx->b = rImage.pPalette[p1].b;
						otpx->g = rImage.pPalette[p1].g;
						otpx->r = rImage.pPalette[p1].r;
						++otpx;
						++inpx;
					}
				}
			}
			break;
		case 32:
			{
				for(s32 h=0; h < th; ++h)
				{
					u8*	inpx = rImage.pXOR + ofs * (sh-h-1);
					IrisRGBQUAD* otpx = (IrisRGBQUAD*)(m_Image.pXOR + IRIS_RoundUp4B(dw*4) * (dh-h-1));
					for(s32 w=0; w < tw; ++w)
					{
						int p1 = *inpx;
						*otpx = rImage.pPalette[p1];
						++otpx;
						++inpx;
					}
				}
			}
			break;
		default:
			return false;
		}
		break;
	case 16:
		ofs = IRIS_RoundUp4B(sw*2);
		switch( dbit )
		{
		//case 1:
		//	break;
		//case 4:
		//	break;
		//case 8:
		//	break;
		case 16:
			{
				for(i=0; i < 65536; ++i )
					m_Image.pPalette[i] = rImage.pPalette[i];
				for(s32 h=0; h < th; ++h )
				{
					memcpy(m_Image.pXOR + IRIS_RoundUp4B(dw*2)*(dh-h-1)
						, rImage.pXOR + ofs * (sh-h-1), IRIS_RoundUp4B(tw*2));
				}
			}
			break;
		case 24:
			{
				for(s32 h=0; h < th; ++h)
				{
					u16*	inpx = (u16*)rImage.pXOR + ofs * (sh-h-1);
					IrisBGR888* otpx = (IrisBGR888*)(m_Image.pXOR + IRIS_RoundUp4B(dw*3) * (dh-h-1));
					for(s32 w=0; w < tw; ++w)
					{
						int p1 = *inpx;
						otpx->b = rImage.pPalette[p1].b;
						otpx->g = rImage.pPalette[p1].g;
						otpx->r = rImage.pPalette[p1].r;
						++otpx;
						++inpx;
					}
				}
			}
			break;
		case 32:
			{
				for(s32 h=0; h < th; ++h)
				{
					u16*	inpx = (u16*)rImage.pXOR + ofs * (sh-h-1);
					IrisRGBQUAD* otpx = (IrisRGBQUAD*)(m_Image.pXOR + IRIS_RoundUp4B(dw*4) * (dh-h-1));
					for(s32 w=0; w < tw; ++w)
					{
						int p1 = *inpx;
						*otpx = rImage.pPalette[p1];
						++otpx;
						++inpx;
					}
				}
			}
			break;
		default:
			return false;
		}
		break;
	case 24:
		ofs = IRIS_RoundUp4B(sw*3);
		switch( dbit )
		{
		//case 1:
		//	break;
		//case 4:
		//	break;
		//case 8:
		//	break;
		//case 16:
		//	break;
		case 24:
			for(s32 h=0; h < th; ++h )
			{
				memcpy(m_Image.pXOR + IRIS_RoundUp4B(dw*3)*(dh-h-1)
					, rImage.pXOR + ofs * (sh-h-1), IRIS_RoundUp4B(tw*3));
			}
			break;
		case 32:
			{
				for(s32 h=0; h < th; ++h)
				{
					IrisBGR888* inpx = (IrisBGR888*)(rImage.pXOR + ofs * (sh-h-1));
					IrisRGBQUAD* otpx = (IrisRGBQUAD*)(m_Image.pXOR + IRIS_RoundUp4B(dw*4) * (dh-h-1));
					for(s32 w=0; w < tw; ++w)
					{
						otpx->b = inpx->b;
						otpx->g = inpx->g;
						otpx->r = inpx->r;
						++otpx;
						++inpx;
					}
				}
			}
			break;
		default:
			return false;
		}
		break;
	case 32:
		ofs = IRIS_RoundUp4B(sw*4);
		switch( dbit )
		{
		//case 1:
		//	break;
		//case 4:
		//	break;
		//case 8:
		//	break;
		//case 16:
		//	break;
		case 24:
			{
				for(s32 h=0; h < th; ++h)
				{
					IrisRGBQUAD* inpx = (IrisRGBQUAD*)(rImage.pXOR + ofs * (sh-h-1));
					IrisBGR888* otpx = (IrisBGR888*)(m_Image.pXOR + IRIS_RoundUp4B(dw*3) * (dh-h-1));
					for(s32 w=0; w < tw; ++w)
					{
						otpx->b = inpx->b;
						otpx->g = inpx->g;
						otpx->r = inpx->r;
						++otpx;
						++inpx;
					}
				}
			}
			break;
		case 32:
			for(s32 h=0; h < th; ++h )
			{
				memcpy(m_Image.pXOR + IRIS_RoundUp4B(dw*4)*(dh-h-1)
					, rImage.pXOR + ofs * (sh-h-1), IRIS_RoundUp4B(tw*4));
			}
			break;
		default:
			return false;
		}
		break;
	default:
		return false;
	}

	// AND
	for(s32 h=0; h < th; ++h )
	{
		memcpy(m_Image.pAND + IRIS_RoundUp4B((dw+7)>>3)*(dh-h-1)
			, rImage.pAND + maskofs * (sh-h-1), IRIS_RoundUp4B((tw+7)>>3));
	}
	return true;
}

/**********************************************************************//**
 *
 * f[^̃obt@TCY擾
 *
 -----------------------------------------------------------------------
 * @return	obt@TCY
*//***********************************************************************/
u32 CIconImage::GetBufferSize(void) const
{
	if( !IsValid() ) return 0;
	u32 size = m_Image.pBmpInfo->biSize;
	size += m_Image.pBmpInfo->biClrUsed * sizeof(IrisRGBQUAD);
	size += m_Image.pBmpInfo->biSizeImage;
	size += CIconFile::GetMaskSize(m_Image.pBmpInfo);
	return size;
}

/**********************************************************************//**
 *
 * f[^Lǂ
 *
 -----------------------------------------------------------------------
 * @return	^Ul
*//***********************************************************************/
bool CIconImage::IsValid(void) const
{
	return m_Image.pBmpInfo != nullptr;
}

/**********************************************************************//**
 *
 * ΉĂBitCountǂ
 *
 -----------------------------------------------------------------------
 * @param [in]	nBitCount	= rbg[x
 * @return	^Ul
*//***********************************************************************/
bool CIconImage::IsSupportedBitCoount(u16 nBitCount)
{
	if( nBitCount == 1
		|| nBitCount == 4
		|| nBitCount == 8
		|| nBitCount == 16
		|| nBitCount == 24
		|| nBitCount == 32
	)
	{
		return true;
	}
	return false;
}

/**********************************************************************//**
 *
 * rbgJEg擾
 *
 -----------------------------------------------------------------------
 * @return	rbgJEg
*//***********************************************************************/
u16 CIconImage::GetBitCount(void) const
{
	if( m_Image.pBmpInfo == nullptr ) return 0;
	return m_Image.pBmpInfo->biBitCount;
}

/**********************************************************************//**
 *
 * C[Wobt@̎擾
 *
 -----------------------------------------------------------------------
 * @return	C[Wobt@
*//***********************************************************************/
u8* CIconImage::GetXOR(void) const
{
	return m_Image.pXOR;
}

/**********************************************************************//**
 *
 * C[Wobt@̎擾
 *
 -----------------------------------------------------------------------
 * @param [in]	x	= xW
 * @param [in]	y	= yW
 * @return	C[W
*//***********************************************************************/
void* CIconImage::GetXOR(s32 x, s32 y) const
{
	if( !IsValid() ) return nullptr;
	s32 w = m_Image.pBmpInfo->biWidth;
	s32 h = m_Image.pBmpInfo->biHeight>>1;
	if( x >= w ) return nullptr;
	if( y >= h ) return nullptr;
	s32 dy = h-y-1;
	u32 lw;
	switch( m_Image.pBmpInfo->biBitCount )
	{
	case 1:
		lw = IRIS_RoundUp4B((w+7)>>3);
		x >>= 3;
		break;
	case 4:
		lw = IRIS_RoundUp4B((w+1)>>1);
		x >>= 1;
		break;
	case 8:
		lw = IRIS_RoundUp4B(w);
		break;
	case 16:
		lw = IRIS_RoundUp4B(w*2);
		x <<= 1;
		break;
	case 24:
		lw = IRIS_RoundUp4B(w*3);
		x *= 3;
		break;
	case 32:
		lw = IRIS_RoundUp4B(w*4);
		x <<= 2;
		break;
	default:
		return nullptr;
	}
	return m_Image.pXOR + lw * dy + x;
}

/**********************************************************************//**
 *
 * }XNC[W̎擾
 *
 -----------------------------------------------------------------------
 * @return	}XNC[W
*//***********************************************************************/
u8* CIconImage::GetAND(void) const
{
	return m_Image.pAND;
}

/**********************************************************************//**
 *
 * }XNC[W̎擾
 *
 -----------------------------------------------------------------------
 * @param [in]	x	= xW
 * @param [in]	y	= yW
 * @return	}XN
*//***********************************************************************/
BOOL CIconImage::GetAND(s32 x, s32 y) const
{
	if( !IsValid() ) return 0;
	s32 w = m_Image.pBmpInfo->biWidth;
	s32 h = m_Image.pBmpInfo->biHeight>>1;
	if( x >= w ) return 0;
	if( y >= h ) return 0;
	s32 dy = h-y-1;
	s32 dx = x>>3;
	u32 lw = IRIS_RoundUp4B((w+7)>>3);
	return (*(m_Image.pAND + lw * dy + dx) >> (x & 0x7)) & 0x1;
}

/**********************************************************************//**
 *
 * }XNC[W̎擾
 *
 -----------------------------------------------------------------------
 * @param [in]	x		= xW
 * @param [in]	y		= yW
 * @param [in]	bAlpha	= }XN
*//***********************************************************************/
bool CIconImage::SetAND(s32 x, s32 y, BOOL bAlpha)
{
	if( !IsValid() ) return false;
	s32 w = m_Image.pBmpInfo->biWidth;
	s32 h = m_Image.pBmpInfo->biHeight>>1;
	if( x >= w ) return false;
	if( y >= h ) return false;
	s32 dy = h-y-1;
	s32 dx = x>>3;
	u32 lw = IRIS_RoundUp4B((w+7)>>3);
	s32 shift = (x & 0x7);
	u8* p = m_Image.pAND + lw * dy + dx;
	*p &= ~(1<<shift);
	u8 mask = bAlpha ? 1<<shift : 0;
	*p |= mask;
	return true;
}

/**********************************************************************//**
 *
 * pbg̎擾
 *
 -----------------------------------------------------------------------
 * @param [in]	idx = pbgCfbNX
 * @return	sNZf[^
*//***********************************************************************/
IrisRGBQUAD* CIconImage::GetPallete(u32 idx) const
{
	if( m_Image.pPalette == nullptr ) return nullptr;
	u32 max = GetPalleteNum();
	if( idx >= max ) return nullptr;
	return &m_Image.pPalette[idx];
}

/**********************************************************************//**
 *
 * pbgobt@̎擾
 *
 -----------------------------------------------------------------------
 * @return	pbgobt@
*//***********************************************************************/
IrisRGBQUAD* CIconImage::GetPallete(void) const
{
	return m_Image.pPalette;
}

/**********************************************************************//**
 *
 * pbǧ擾
 *
 -----------------------------------------------------------------------
 * @return	pbgobt@
*//***********************************************************************/
u32 CIconImage::GetPalleteNum(void) const
{
	if( m_Image.pBmpInfo == nullptr ) return 0;
	return m_Image.pBmpInfo->biClrUsed;
}

/**********************************************************************//**
 *
 * sNZJ[̎擾
 *
 -----------------------------------------------------------------------
 * @param [in]	x	= xW
 * @param [in]	y	= yW
 * @return	sNZRGBA
*//***********************************************************************/
bool CIconImage::GetPixelRGBA8888(s32 x, s32 y, IrisRGBA8888& rgba) const
{
	void* pixel = GetXOR(x, y);
	if( pixel == nullptr ) return false;
	IrisRGBQUAD rgbq;
	int idx = 0;
	switch( m_Image.pBmpInfo->biBitCount )
	{
	case 1:
		idx = (*(u8*)(pixel) >> (x & 0x7)) & 0x1;
		rgbq = *(m_Image.pPalette + idx);
		break;
	case 4:
		idx = (*(u8*)(pixel) >> ((x & 0x1) << 2)) & 0xF;
		rgbq = *(m_Image.pPalette + idx);
		break;
	case 8:
		idx = *(u8*)pixel;
		rgbq = *(m_Image.pPalette + idx);
		break;
	case 16:
		idx = *(u16*)pixel;
		rgbq = *(m_Image.pPalette + idx);
		break;
	case 24:
		{
			IrisBGR888* tmp = (IrisBGR888*)pixel;
			rgbq.r = tmp->r;
			rgbq.g = tmp->g;
			rgbq.b = tmp->b;
			rgbq.Re = 0;
		}
		break;
	case 32:
		{
			rgbq = *(IrisRGBQUAD*)(pixel);
		}
		break;
	default:
		return false;
	}
	rgba.r = rgbq.r;
	rgba.g = rgbq.g;
	rgba.b = rgbq.b;
	rgba.a = GetAND(x, y) ? 0x00 : 0xFF;
	return true;
}

/**********************************************************************//**
 *
 * sNZJ[̐ݒ
 *
 -----------------------------------------------------------------------
 * @param [in]	x		= xW
 * @param [in]	y		= yW
 * @param [in]	rgba	= sNZRGBA
*//***********************************************************************/
bool CIconImage::SetPixelRGBA8888(s32 x, s32 y, const IrisRGBA8888& rgba)
{
	void* pixel = GetXOR(x, y);
	if( pixel == nullptr ) return false;
	IrisRGBQUAD rgbq;
	rgbq.col = rgba.col;
	rgbq.Re = 0;
	int idx = 0;
	switch( m_Image.pBmpInfo->biBitCount )
	{
	case 1:
		idx = (*(u8*)(pixel) >> (x & 0x7)) & 0x1;
		*(m_Image.pPalette + idx) = rgbq;
		break;
	case 4:
		idx = (*(u8*)(pixel) >> ((x & 0x1) << 2)) & 0xF;
		*(m_Image.pPalette + idx) = rgbq;
		break;
	case 8:
		idx = *(u8*)pixel;
		*(m_Image.pPalette + idx) = rgbq;
		break;
	case 16:
		idx = *(u16*)pixel;
		*(m_Image.pPalette + idx) = rgbq;
		break;
	case 24:
		{
			IrisBGR888* tmp = (IrisBGR888*)pixel;
			tmp->r = rgbq.r;
			tmp->g = rgbq.g;
			tmp->b = rgbq.b;
		}
		break;
	case 32:
		{
			*(IrisRGBQUAD*)(pixel) = rgbq;
		}
		break;
	default:
		return false;
	}
	SetAND(x, y, rgba.a);
	return true;
}

}	// end of namespace wx
}	// end of namespace iris
