//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXKeyboard.h
 * @brief		L[{[h t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXKeyboard_H_
#define INCG_IRIS_WXKeyboard_H_

//======================================================================
// include
#include "fnd/pad/FndKeyState.h"

#if !defined(IRIS_WIN32_WCE)

namespace iris {
namespace wx
{

//======================================================================
// class
/**
 * @brief	L[{[hNX
*/
class CKeyboard : public IIrisObject
{
public:
	static const int MAX_KEYFRAMES = 256;

public:

	/// L[Xe[g擾NX
	class CKeyState : public fnd::IKeyState
	{
		u8			m_Key;
		CKeyboard*	m_pKeyboard;

	public:
		/// RXgN^
		CKeyState(u8 key, CKeyboard* pKeyboard) : m_Key(key), m_pKeyboard(pKeyboard) {}

	public:
		virtual	bool	Prev(void)	const { return (m_pKeyboard->GetState(m_Key) & 0x80) != 0; }
		/// 
		virtual bool	Hold(void)	const { return (m_pKeyboard->GetState(m_Key) & 0x80) != 0; }
	};

public:
	typedef union KEYSTATE
	{
		u8	state;
		struct
		{
#ifdef _IRIS_BITFIELD_HIGHASSGIN
			u8	hold:1;
			u8	prev:1;
			u8	cnt:6;
#else
			u8	cnt:6;
			u8	prev:1;
			u8	hold:1;
#endif
		};
	} KEYSTATE;

private:
	u8	m_State[MAX_KEYFRAMES];
public:
	// RXgN^
	CKeyboard(void);
	// fXgN^
	~CKeyboard(void);

public:
	// XV
	bool	Update(void);

public:
	// L[Ԃ̎擾
	u8		GetState(u8 nIndex) const;

};

}	// end of namespace wx
}	// end of namespace iris

#endif

#endif
