//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXHID.cpp
 * @brief		WXHID t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 *
 * @par			copyright
 * Copyright (C) 2010 t.sirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXHID_CPP_

//======================================================================
// include
#include "WXHID.h"

#if	defined(_IRIS_SUPPORT_WDK)

namespace iris {
namespace wx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * HID ̗
 *
*//***********************************************************************/
BOOL CHID::EnumHID(ENUMHIDSPROC lpCallback, LPVOID lpUser)
{
	if( lpCallback == nullptr ) return FALSE;
	GUID guid;
	CHidLib::HidD_GetHidGuid(&guid);

	CDevInfo devinfo;
	if( !devinfo.GetClassDevs(&guid, nullptr, nullptr, DIGCF_PRESENT | DIGCF_DEVICEINTERFACE) )
	{
		return FALSE;
	}

	DWORD index=0;
	while(1)
	{
		SP_DEVICE_INTERFACE_DATA spid = {0};
		PSP_DEVICE_INTERFACE_DETAIL_DATA psdidd = nullptr;

		ZeroMemory(&spid, sizeof(spid));
		spid.cbSize = sizeof(SP_DEVICE_INTERFACE_DATA);
		if( !SetupDiEnumDeviceInterfaces(devinfo, nullptr, &guid, index, &spid) )
			break;

		DWORD dwSize = 0;
		SetupDiGetDeviceInterfaceDetail(devinfo, &spid, nullptr, 0, &dwSize, nullptr);
		psdidd = static_cast<PSP_DEVICE_INTERFACE_DETAIL_DATA>(malloc(dwSize));
		psdidd->cbSize = sizeof(SP_DEVICE_INTERFACE_DETAIL_DATA);
		SetupDiGetDeviceInterfaceDetail(devinfo, &spid, psdidd, dwSize, &dwSize, nullptr);

		if( !lpCallback(psdidd->DevicePath, &spid, lpUser) )
		{
			free(psdidd);
			break;
		}
		free(psdidd);
		++index;
	}
	return TRUE;
}

/**********************************************************************//**
 *
 * ΏۃfoCXǂf
 *
 -----------------------------------------------------------------------
 * @param [in]	lpDevicePath	= foCX̃pX
 * @param [in]	VendorID		= x_[ID
 * @param [in]	ProductID		= v_NgID
 * @return	
*//***********************************************************************/
bool CHID::IsSpecifiedDevice(LPCTSTR lpDevicePath, USHORT VendorID, USHORT ProductID)
{
	CHID hid;
	if( !hid.Open(lpDevicePath, 0, FILE_SHARE_READ | FILE_SHARE_WRITE
		, nullptr, OPEN_EXISTING, 0, nullptr) ) return false;
	HIDD_ATTRIBUTES attr;
	if( !hid.GetAttributes(&attr) ) return false;
	return ( attr.VendorID == VendorID ) && ( attr.ProductID == ProductID );
}

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CHID::CHID(void)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CHID::~CHID(void)
{
}

/**********************************************************************//**
 *
 * ̎擾
 *
 -----------------------------------------------------------------------
 * @param [out]	lpAttr	= 
 * @return	
*//***********************************************************************/
BOOL CHID::GetAttributes(PHIDD_ATTRIBUTES lpAttr) const
{
	return CHidLib::HidD_GetAttributes(m_hObject, lpAttr);
}

/**********************************************************************//**
 *
 * x_[ID ̎擾
 *
 -----------------------------------------------------------------------
 * @return	x_[ID
*//***********************************************************************/
USHORT CHID::GetVendorID(void) const
{
	HIDD_ATTRIBUTES attr;
	if( !GetAttributes(&attr) ) return 0;
	return attr.VendorID;
}

/**********************************************************************//**
 *
 * v_NgID ̎擾
 *
 -----------------------------------------------------------------------
 * @return	v_NgID
*//***********************************************************************/
USHORT CHID::GetProductID(void) const
{
	HIDD_ATTRIBUTES attr;
	if( !GetAttributes(&attr) ) return 0;
	return attr.ProductID;
}

/**********************************************************************//**
 *
 * o[W ̎擾
 *
 -----------------------------------------------------------------------
 * @return	o[W
*//***********************************************************************/
USHORT CHID::GetVersionNumber(void) const
{
	HIDD_ATTRIBUTES attr;
	if( !GetAttributes(&attr) ) return 0;
	return attr.VersionNumber;
}

/**********************************************************************//**
 *
 * o[W ̎擾
 *
 -----------------------------------------------------------------------
 * @param [out]	lpBuffer	= o̓obt@
 * @param [in]	ulLength	= o̓obt@TCY
 * @return	
*//***********************************************************************/
BOOL CHID::GetSerialNumberString(PVOID lpBuffer, ULONG ulLength) const
{
	return CHidLib::HidD_GetSerialNumberString(m_hObject, lpBuffer, ulLength);
}

/**********************************************************************//**
 *
 * ̎擾
 *
 -----------------------------------------------------------------------
 * @param [out]	pphpd	= o
 * @return	
*//***********************************************************************/
BOOL CHID::GetPreparsedData(PHIDP_PREPARSED_DATA* pphpd) const
{
	return CHidLib::HidD_GetPreparsedData(m_hObject, pphpd);
}

}	// end of namespace wx
}	// end of namespace iris

#endif
