//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXGdiPen.h
 * @brief		GDIyIuWFNgNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXGdiPen_CPP_

//======================================================================
// include
#include "WXGdiPen.h"

namespace iris {
namespace wx
{

//======================================================================
// class

// CGDIPen
/**********************************************************************//**
 *
 * y̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	nStyle	= X^C(PS_***)
 * @param [in]	nWidth	= 
 * @param [in]	color	= F
 * @return	
*//***********************************************************************/
BOOL CGDIPen::Create(UINT nStyle, LONG nWidth, COLORREF color)
{
	LOGPEN pen;
	pen.lopnStyle	= nStyle;
	pen.lopnWidth.x	= nWidth;
	pen.lopnColor	= color;
	return Create(&pen);
}

/**********************************************************************//**
 *
 * y̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	lppen	= y
 * @return	
*//***********************************************************************/
BOOL CGDIPen::Create(const PLOGPEN lppen)
{
	if( m_hObject != nullptr ) return FALSE;
	HPEN hPen = CreatePenIndirect(lppen);
	return TryAttach(hPen);
}

/**********************************************************************//**
 *
 * y̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	dwStyle			= ỹ^CvAX^CA[_LbvA
 * @param [in]	dwWidth			= y̕
 * @param [in]	lpBrush			= uV̑
 * @param [in]	dwSytleCount	= JX^X^Cz̃TCY
 * @param [in]	lpdwStyle		= JX^X^Cz
 * @return	
*//***********************************************************************/
BOOL CGDIPen::CreateEx(DWORD dwStyle, DWORD dwWidth, const PLOGBRUSH lpBrush
					   , DWORD dwSytleCount, const LPDWORD lpdwStyle)
{
	if( m_hObject != nullptr ) return FALSE;
	HPEN hPen = ExtCreatePen(dwStyle, dwWidth, lpBrush, dwSytleCount, lpdwStyle);
	return TryAttach(hPen);
}

/**********************************************************************//**
 *
 * y̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	nWidth	= 
 * @param [in]	color	= F
 * @return	
*//***********************************************************************/
BOOL CGDIPen::CreateSolid(LONG nWidth, COLORREF color)
{
	return Create(PS_SOLID, nWidth, color);
}

}	// end of namespace wx
}	// end of namespace iris
