//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXGdiObject.h
 * @brief		GDIIuWFNgx[XNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXGdiObject_H_
#define INCG_IRIS_WXGdiObject_H_

//======================================================================
// include
#include "../base/WXHandle.h"

namespace iris {
namespace wx
{

//======================================================================
// declare
class CGDIObject;
class CGDISelectObject;

//======================================================================
// class
//! GDIIuWFNgNXev[g
template<typename TN_>
class CGDIObjectBase : private INonCopyable< CGDIObjectBase<TN_> >, public IHandleBase<TN_>
{
	typedef CGDIObjectBase<TN_>	_Myt;
public:
	/// RXgN^
	CGDIObjectBase(void)		{}
	/// RXgN^
	explicit CGDIObjectBase(TN_ hObj)	{ Attach(hObj); }
	/// RXgN^
	CGDIObjectBase(_Myt& rObj)			{ Attach(rObj.Detach()); }

	/// fXgN^
	virtual ~CGDIObjectBase(void)		{ Delete(); }

public:
	/// ֘Ats
	virtual	BOOL	TryAttach(TN_ hObj)	{ if( !Attach(hObj) ) { ::DeleteObject(hObj); return FALSE; } return TRUE; }

public:
	/// IuWFNg̍폜
			BOOL	Delete(void)	{ return DeleteObject(Detach()); }
	virtual	bool	Close(void)		{ return IRIS_TO_bool(Delete()); }

public:
	/// LȃIuWFNgێĂ邩
	bool	IsValid(void) const		{ return m_hObject != nullptr; }
public:
	/// IuWFNg̎擾
	int		GetObjectA(LPVOID lpBuffer, int nSize) const		{ return ::GetObjectA(m_hObject, nSize, lpBuffer); }
	int		GetObjectW(LPVOID lpBuffer, int nSize) const		{ return ::GetObjectW(m_hObject, nSize, lpBuffer); }

public:
	/// ev[g^ϊ
	template<typename TT>
	CGDIObjectBase(CGDIObjectBase<TT>& rGDI)			{ Attach(rGDI.Detach()); }
	/// ev[g^ϊ
	template<typename TT>
	void	operator	= (CGDIObjectBase<TT>& rObj)	{ Attach(rObj.Detach()); }

#if	defined(STRICT) && STRICT
	// ^̌ɑΉ
	operator	HGDIOBJ (void)				{ return static_cast<HGDIOBJ>(GetHandle()); }
#endif

	_Myt&	operator	= (TN_ hObj)		{ Attach(hObj); return *this; }
};

//! GDIIuWFNgNX
class CGDIObject : public CGDIObjectBase<HGDIOBJ>
{
	typedef CGDIObjectBase<HGDIOBJ>	_Mybase;
public:
	// RXgN^
	CGDIObject(void)	{}

#ifdef STRICT
	// ^̌ɑΉ
	/// RXgN^
	CGDIObject(HBRUSH	hObj) : _Mybase(hObj) 		{}
	CGDIObject(HBITMAP	hObj) : _Mybase(hObj) 		{}
	CGDIObject(HPEN		hObj) : _Mybase(hObj) 		{}

			operator	HBRUSH	(void)		{ return static_cast<HBRUSH>(GetHandle()); }
			operator	HBITMAP	(void)		{ return static_cast<HBITMAP>(GetHandle()); }
			operator	HPEN	(void)		{ return static_cast<HPEN>(GetHandle()); }

	CGDIObject&	operator	= (HBRUSH	hObj)	{ Attach(hObj); return *this; }
	CGDIObject&	operator	= (HBITMAP	hObj)	{ Attach(hObj); return *this; }
	CGDIObject&	operator	= (HPEN		hObj)	{ Attach(hObj); return *this; }
#endif
};

//! HDC,GDIIuWFNgselectNX
class CGDISelectObject : private INonCopyable<CGDISelectObject>
{
protected:
	HDC			m_hDC;	//!< HDC
	HGDIOBJ		m_hOld;	//!< ȑOGDIIuWFNg

public:
	// RXgN^
	CGDISelectObject(void);
	CGDISelectObject(HDC hDC);
	CGDISelectObject(HDC hDC, HGDIOBJ hObj);

	// fXgN^
	~CGDISelectObject(void);

public:
	// GDIIuWFNg̊֘At
	BOOL	Attach(HDC hDC);
	// ֘At̉
	HDC		Detach(void);

public:
	// GDIIuWFNg̑I
	HGDIOBJ	SelectObject(HGDIOBJ hObj);
	HGDIOBJ	SelectObject(HDC hDC, HGDIOBJ hObj);
	// 
	void	Release(void);

public:
	/// ȑÕIuWFNg擾
	HGDIOBJ	GetOld(void) const	{ return m_hOld; }
};

}	// end of namespace wx
}	// end of namespace iris

#endif
