//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXGdiObject.cpp
 * @brief		GDIIuWFNgx[XNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXGdiObject_CPP_

//======================================================================
// include
#include "WXGdiObject.h"

namespace iris {
namespace wx
{

//======================================================================
// class

// CGDISelectObject
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CGDISelectObject::CGDISelectObject(void)
: m_hDC(nullptr)
, m_hOld(nullptr)
{
}

/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	hDC	= ֘AtIuWFNg
*//***********************************************************************/
CGDISelectObject::CGDISelectObject(HDC hDC)
: m_hOld(nullptr)
{
	Attach(hDC);
}

/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	hDC	= ֘AtIuWFNg
*//***********************************************************************/
CGDISelectObject::CGDISelectObject(HDC hDC, HGDIOBJ hObj)
: m_hOld(nullptr)
{
	SelectObject(hDC, hObj);
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CGDISelectObject::~CGDISelectObject(void)
{
	Release();
}

/**********************************************************************//**
 *
 * ֘At
 *
 ----------------------------------------------------------------------
 * @param [in]	hDC	= ֘AtIuWFNg
 * @return	
*//***********************************************************************/
BOOL CGDISelectObject::Attach(HDC hDC)
{
	if( hDC == nullptr || m_hDC != nullptr ) return FALSE;
	m_hDC = hDC;
	return TRUE;
}

/**********************************************************************//**
 *
 * ֘At̉
 *
 * @note	Ȃ̂Œ
 *
 ----------------------------------------------------------------------
 * @return	ȑOɊ֘AtĂIuWFNg
*//***********************************************************************/
HDC CGDISelectObject::Detach(void)
{
	HDC hPre = m_hDC;
	m_hDC = nullptr;
	return hPre;
}

/**********************************************************************//**
 *
 * GDIIuWFNg̑I
 *
 ----------------------------------------------------------------------
 * @param [in]	hObj	= IIuWFNg
 * @return	ȑÕIuWFNg
*//***********************************************************************/
HGDIOBJ CGDISelectObject::SelectObject(HGDIOBJ hObj)
{
	if( m_hDC == nullptr ) return nullptr;
	HGDIOBJ	hOld = ::SelectObject(m_hDC, hObj);
	if( m_hOld == nullptr ) m_hOld = hOld;
	return hOld;
}

/**********************************************************************//**
 *
 * GDIIuWFNg̑I
 *
 ----------------------------------------------------------------------
 * @param [in]	hObj	= IIuWFNg
 * @return	ȑÕIuWFNg
*//***********************************************************************/
HGDIOBJ CGDISelectObject::SelectObject(HDC hDC, HGDIOBJ hObj)
{
	Release();
	Detach();
	Attach(hDC);
	return SelectObject(hObj);
}

/**********************************************************************//**
 *
 * iSelectObject܂̃IuWFNgɖ߂j
 *
*//***********************************************************************/
void CGDISelectObject::Release(void)
{
	if( m_hDC == nullptr ) return;
	::SelectObject(m_hDC, m_hOld);
	m_hOld = nullptr;
}

}	// end of namespace wx
}	// end of namespace iris
