//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXSplashWindow.h
 * @brief		AvP[Vʒm_CAO
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXSplashWindow_H_
#define INCG_IRIS_WXSplashWindow_H_

//======================================================================
// include
#include "../../app/WXDlgBase.h"
#include "../../os/WXCRTThread.h"
#include <map>

namespace iris {
namespace wx
{

//======================================================================
// decalre
template<class _TC, typename Functor, class SplashWindowBase>
class CSplashWindowFunctor;
class CSplashWindow;
class CSplashWindowEx;

//======================================================================
// class
//! AvP[VʒmNX
class CSplashWindow : public CDlgBase, public CThreadEntry<CCRTThread>
{
protected:
	// eEBhE
	HWND	m_hParent;
protected:
	// RXgN^
	CSplashWindow(void);
	// fXgN^
	virtual ~CSplashWindow(void);
public:
	// s
	virtual	bool	Exec(void);
	// Sleep
	void	Sleep(DWORD dwMilliseconds);
	// I
	void	Exit(void);

protected:
	// 
	virtual bool	OnInit(void) { return true; }
	// Xbh̎s
	virtual	DWORD	Run(void);
};

//! AvP[VʒmNX
class CSplashWindowEx : public CSplashWindow
{
public:
	/// Rg[̗LE
	typedef enum
	{
		INITWND_ICON		= 0x00000001,	//!< ACR
		INITWND_PROGRESS	= 0x00000002,	//!< vOXo[
		INITWND_BITMAP		= 0x00000004,	//!< rbg}bv
		INITWND_MASKBITMAP	= 0x00000008,	//!< rbg}bv
		INITWND_TEXT1		= 0x00000010,	//!< eLXg1
		INITWND_TEXT2		= 0x00000020,	//!< eLXg2
		INITWND_APPNAME		= 0x00000100,	//!< AvP[V
		INITWND_VERSION		= 0x00000200,	//!< o[W
		INITWND_COPYRIGHT	= 0x00000400,	//!< Copyright
		INITWND_COMPANYNAME	= 0x00000800,	//!< Ж
		INITWND_ALL			= 0xffffffff,

		INITWND_TEXTS		= 0x00000030,	//!< eLXg1,2

		INITWND_VI			= 0x00000f00,	//!< o[W\[XQ
	} INITWND_FLAGS;

	typedef struct WINDOWINFO
	{
		HINSTANCE	hInstance;
		int			width, height;
		s32			uFlags;
		UINT		uIcon;
		UINT		uBitmap;
		HGDIOBJ		hFont;
	} WINDOWINFO;
private:
	typedef std::map<UINT, CWindow*>	CtrlMap;
	typedef std::pair<UINT, CWindow*>	CtrlPair;

protected:
	CtrlMap	m_Controls;	//!< EBhEXg
	WINDOWINFO m_Info;

public:
	// RXgN^
	CSplashWindowEx(void);
	// fXgN^
	virtual ~CSplashWindowEx(void);

protected:
	// EBhEvV[W
	virtual LRESULT	WndProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam);
	// Rg[擾
	CWindow*		GetControl(UINT uFlag);

public:
	// ݒ
	void	Setup(HINSTANCE hInstance, HWND hParent, int width, int height
		, s32 uFlags, UINT uIcon, UINT uBitmap
		, HGDIOBJ hFont=nullptr);

public:
	// vOXo[ʒu̐ݒ
	void	SetProgressRatio(float ratio);
	// vOXo[ʒủZ
	void	AddProgressRatio(float ratio);
	// eLXgݒ
	BOOL	SetText(UINT uFlag, LPCTSTR lpszText);
	// tHgݒ
	void	SetFont(UINT uFlag, HGDIOBJ hFont, BOOL Redraw);

protected:
	// 
	virtual bool	OnInit(void);
};

//======================================================================
//! AvP[VʒmNX
template<class _TC, typename Functor, class SplashWindowBase>
class CSplashWindowFunctor : public SplashWindowBase
{
	typedef SplashWindowBase	_Mybase;
	typedef _TC					*value_ptr;

private:
	value_ptr	m_pFunctor;
public:
	// RXgN^
	CSplashWindowFunctor(value_ptr p) : m_pFunctor(p) {}
	// fXgN^
	virtual ~CSplashWindowFunctor(void)			{}
public:
	// s
	virtual	bool	Exec(void)
	{
		OnInit();
		// XbhJn
		CreateStart();
		// őOʂ
		SetForegroundWindow();
		// CEChE𖳌ă[_
		::EnableWindow(m_hParent, FALSE);
		// [_Ŏs
		DoModal();

		// CEChELɂă[_
		//ShowWindow(SW_HIDE);
		::EnableWindow(m_hParent, TRUE);
		::BringWindowToTop(m_hParent);

		// eEBhEtH[JX
		::SetFocus(m_hParent);
		return IRIS_TO_bool(m_ExitCode);
	}

protected:
	// Xbh̎s
	virtual	DWORD	Run(void)
	{
		DWORD dwExitCode = (DWORD)Functor()(m_pFunctor, this);
		EndDialog(dwExitCode);
		CThreadEntry::Exit(dwExitCode);
		return dwExitCode;
	}
};

}	// end of namespace wx
}	// end of namespace iris

#endif
