//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXExplorer.h
 * @brief		WXExplorer t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXExplorer_H_
#define INCG_IRIS_WXExplorer_H_

//======================================================================
// include
#include "../../shell/WXSHExecute.h"

namespace iris {
namespace wx
{

//======================================================================
// declare
template<typename CHARTYPE_>class CTExplorer;

//======================================================================
// typedef
typedef CTExplorer<CHAR>	CExplorerA;
typedef CTExplorer<WCHAR>	CExplorerW;
typedef CTExplorer<TCHAR>	CExplorer;

//======================================================================
// class
/**
 * @brief	GNXv[[
*/
template<typename CHARTYPE_>
class CTExplorer : public CTSHExecute<CHARTYPE_>
{
	typedef CHARTYPE_		_Mychar;
	typedef CHARTYPE_		*_Mylpstr;
	typedef const CHARTYPE_	*_Mylpcstr;

public:
	static HINSTANCE	Open(HWND hwnd, _Mylpcstr lpPath, _Mylpcstr lpParameters
					, _Mylpcstr lpDirectory, INT nShowCmd);
	static HINSTANCE	OpenByFile(HWND hwnd, _Mylpcstr lpFile
					, _Mylpcstr lpDirectory, INT nShowCmd);
};

}	// end of namespace wx
}	// end of namespace iris


#endif
