//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXFindThread.cpp
 * @brief		Thread NX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXFindThread_CPP_

//======================================================================
// include
#include "WXFindThread.h"
#include <tchar.h>

namespace iris {
namespace wx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CFindThread::CFindThread(void)
{
	SecureZeroMemory(&m_Entry, sizeof(m_Entry));
	m_Entry.dwSize = sizeof(m_Entry);
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CFindThread::~CFindThread(void)
{
}

/**********************************************************************//**
 *
 * vZXID猟
 *
 -----------------------------------------------------------------------
 * @param [in]	dwOwnerProcessId	= vZXID
 * @return	XbhID
*//***********************************************************************/
DWORD CFindThread::FindThreadId(DWORD dwOwnerProcessId)
{
	CToolHelp toolhelp = CToolHelp::CreateImplement();
	if( (toolhelp.GetFlags() & TH32CS_SNAPTHREAD) == 0 )
	{
		if( !toolhelp.Open(toolhelp.GetFlags() | TH32CS_SNAPTHREAD) ) return 0;
	}
	if( toolhelp.Thread32First(&m_Entry) )
	{
		while(1)
		{
			if( m_Entry.th32OwnerProcessID == dwOwnerProcessId )
			{
				return m_Entry.th32ThreadID;
			}
			if( !toolhelp.Thread32Next(&m_Entry) ) break;
		}
	}
	return 0;
}

/**********************************************************************//**
 *
 * vZXID玟
 *
 -----------------------------------------------------------------------
 * @param [in]	dwOwnerProcessId	= vZXID
 * @return	XbhID
*//***********************************************************************/
DWORD CFindThread::FindThreadIdNext(DWORD dwOwnerProcessId)
{
	CToolHelp toolhelp = CToolHelp::CreateImplement();
	while(1)
	{
		if( !toolhelp.Thread32Next(&m_Entry) ) break;
		if( m_Entry.th32OwnerProcessID == dwOwnerProcessId )
		{
			return m_Entry.th32ThreadID;
		}
	}
	return 0;
}

}	// end of namespace wx
}	// end of namespace iris

#if	(defined(_IRIS_SUPPORT_GOOGLETEST) || defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))

//======================================================================
// include
#include "unit/gt/gt_inchead.h"
#include "iris_using.h"

TEST(CFindThreadTest, Function)
{
	CFindThread find;
	ASSERT_NE( 0, find.FindThreadId(::GetCurrentProcessId()) );
}

#endif
