//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXFindModule.h
 * @brief		Module NX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXFindModule_H_
#define INCG_IRIS_WXFindModule_H_

//======================================================================
// include
#include "WXToolHelp.h"
#include "c++0x/cpp0x_type_traits.hpp"

namespace iris {
namespace wx
{

//======================================================================
// decalre
template<typename CHARTYPE_>class CTFindModule;

//======================================================================
// typedef
typedef CTFindModule<CHAR>	CFindModuleA;
typedef CTFindModule<WCHAR>	CFindModuleW;
typedef CTFindModule<TCHAR>	CFindModule;

//======================================================================
// class
/// vZXNX
template<typename CHARTYPE_>
class CTFindModule : public IIrisObject
{
	typedef CTFindModule<CHARTYPE_>	_Myt;
protected:
	typedef	CHARTYPE_			_Mychar;
	typedef CHARTYPE_			*_Mylpstr;
	typedef const CHARTYPE_		*_Mylpcstr;

#if	!defined(IRIS_WIN32_WCE)
	typedef typename iml::type_select< (cpp0x::is_same<CHARTYPE_, WCHAR>::value), MODULEENTRY32W, MODULEENTRY32 >::type XMODULEENTRY32;
#else
	typedef MODULEENTRY32			XMODULEENTRY32;
#endif
	typedef XMODULEENTRY32			*LPXMODULEENTRY32;
	typedef const XMODULEENTRY32	*LPCXMODULEENTRY32;
protected:
	XMODULEENTRY32	m_Entry;	//!< Gg
public:
	// RXgN^
	CTFindModule(void);
	// fXgN^
	~CTFindModule(void);

public:
	// vZX猟
	HMODULE	FindModule(DWORD dwProcessId);
	// vZX玟
	HMODULE	FindModuleNext(DWORD dwProcessId);

	// st@CpX猟
	HMODULE	FindModule(_Mylpcstr lpszExePath);
	// st@CpX
	HMODULE	FindModuleNext(_Mylpcstr lpszExePath);

public:
	/// Gg̎擾
	LPCXMODULEENTRY32	GetEntry(void) const { return &m_Entry; }
};

}	// end of namespace wx
}	// end of namespace iris

#endif
