//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXDrive.h
 * @brief		 Drive t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXDrive_H_
#define INCG_IRIS_WXDrive_H_

//======================================================================
// include
#include "../io/WXDevice.h"
#include "iris_xchar.hpp"

#if defined(_IRIS_SUPPORT_WDK)

namespace iris {
namespace wx
{

//======================================================================
// class
/**
 * @brief	hCuNX
*/
class CDrive : public CDevice
{
public:
	static const int	DRIVE_NUMBER_MAX = 'z' - 'a';
public:
	// RXgN^
	CDrive(void);

public:
	// WIg̎擾
	virtual bool	GetGeometry(PDISK_GEOMETRY geo) const;
	virtual bool	GetGeometryEx(PDISK_GEOMETRY_EX geo) const;

public:
	// ZN^TCY̎擾
	u32		GetSectorSize(void)	const;
	// fBXNTCY擾
	u64		GetDiskSize(void)	const;

public:
	// hCu^CvhCuԍ
	static int	FindDrive(UINT DriveType, int firstDrive=0);
	// hCuԍhCu^Cv擾
	static UINT	GetDriveType(int driveNumber);
	// hCuԍ烋[gpX擾
	template<typename CHARTYPE_>
	static bool	GetDriveRoot(int driveNumber, CHARTYPE_* dst, size_t length)
	{
		if( dst == nullptr ) return false;
		if( length < 4 ) return false;
		if( driveNumber < 0 || driveNumber > DRIVE_NUMBER_MAX ) return false;
		dst[0] = IRIS_XTEXT(CHARTYPE_, 'A') + driveNumber;
		dst[1] = IRIS_XTEXT(CHARTYPE_, ':');
		dst[2] = IRIS_XTEXT(CHARTYPE_, '\\');
		dst[3] = 0;
		return true;
	}

	// hCuԍANZXpX擾
	template<typename CHARTYPE_>
	static bool	GetDriveAccessPath(int driveNumber, CHARTYPE_* dst, size_t length)
	{
		if( dst == nullptr ) return false;
		if( length < 7 ) return false;
		if( driveNumber < 0 || driveNumber > DRIVE_NUMBER_MAX ) return false;
		dst[0] = IRIS_XTEXT(CHARTYPE_, '\\');
		dst[1] = IRIS_XTEXT(CHARTYPE_, '\\');
		dst[2] = IRIS_XTEXT(CHARTYPE_, '.');
		dst[3] = IRIS_XTEXT(CHARTYPE_, '\\');
		dst[4] = IRIS_XTEXT(CHARTYPE_, 'A') + driveNumber;
		dst[5] = IRIS_XTEXT(CHARTYPE_, ':');
		dst[6] = 0;
		return true;
	}
};

}	// end of namespace wx
}	// end of namespace iris

#endif

#endif
