//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXDebugUnitTest.h
 * @brief		P̃eXgT|[gt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXDebugUnitTest_H_
#define INCG_IRIS_WXDebugUnitTest_H_

#if (!defined(_IRIS_UNITTEST) && !defined(_IRIS_MULTI_UNITTEST) )

//======================================================================
// define

#else

//======================================================================
// include
#include "../WXDebugUnLeakCheckMacro.h"	// cpp̍ŉɋLq邱Ƃ̂
#include "unit/UnitCore.h"
#include "../../app/WXWindow.h"

namespace iris {
namespace wx {
namespace dbg
{

//======================================================================
// function
// eXgpEBhEvV[W
LRESULT CALLBACK UnitTest_WindowProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam);
// eXgpEBhE̍쐬
HWND	CreateUnitTestWindow(UINT uStyleEx, LPCTSTR lpClassName, LPCTSTR lpWindowName, UINT uStyle
						  , int nWidth = CW_USEDEFAULT, int nHeight = 0
						  , WNDPROC WndProc = UnitTest_WindowProc);
// C[v
void	UnitTestMainLoop(HWND hWnd, void (*func)(void* arg) = nullptr, void* arg = nullptr);

// class
template<typename TC>
class CUnitTest : public iris::unit::CUnitTest<TC>
{
	typedef CUnitTest<TC>	_Myt;
public:
	static const int WINDOW_STYLE	= ( WS_CAPTION | WS_SYSMENU | WS_MINIMIZEBOX | WS_MAXIMIZEBOX );
	static const int WINDOW_STYLEEX	= ( WS_EX_OVERLAPPEDWINDOW );

public:
	virtual void	OnPaint(HWND hWnd) {}
public:
	static LRESULT CALLBACK DrawTestWindowProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
	{
		// bZ[W̏
		switch( uMsg )
		{
		case WM_PAINT:
			{
				_Myt* p = GetCurrent();
				p->OnPaint(hWnd);
			}
			break;
		default:
			return UnitTest_WindowProc( hWnd, uMsg, wParam, lParam );
		}

		return 0L;
	}
};

}	// end of namespace dbg
}	// end of namespace wx
}	// end of namespace iris

#endif

#endif
